% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OSS_fast_crossfit.R
\name{oss_estimator}
\alias{oss_estimator}
\title{Linear regression with missing data}
\usage{
oss_estimator(formula, data,
              all_weights_one = FALSE,
              crossfitting = FALSE)
}
\arguments{
\item{formula}{A model formula specifying the linear regression, e.g. \code{y ~ x1 + x2}.}

\item{data}{A data.frame containing the variables in the model. Rows with missing
responses are treated as unlabelled observations.}

\item{all_weights_one}{Logical; if TRUE, all missingness-pattern weights are set to one, yielding an
unweighted OSS estimator.}

\item{crossfitting}{Logical; if TRUE, a two-fold cross-fitted version of the OSS estimator is
used.}
}
\value{
An invisible list with components:
\describe{
\item{coef}{Numeric vector of estimated regression coefficients.}
\item{sigma2_hat}{Estimated noise variance, or \code{NA} if not computed.}
\item{weights}{Named vector of weights associated with each missingness pattern.}
\item{groups}{Data.frame mapping labelled observations to missingness patterns.}
\item{beta_cc}{Complete-case coefficient estimates if used, otherwise \code{NULL}.}
}
}
\description{
Fits a linear regression model in the presence of missing covariates and/or
missing responses using the OSS (Ordinary Semi-Supervised) estimator. This corresponds
to Section 2 of \insertCite{RisebrowSSLR;textual}{LRMiss}.
The method exploits partially observed covariates and optionally unlabelled
observations to improve estimation efficiency. If sufficient complete cases are present,
the weights are estimated from them, otherwise the weights are estimated using an
initial consistent estimate. If sufficient unlabelled data is present the covariance
matrix is estimated exclusively from them, otherwise the covariance is estimated
elementwise.
}
\examples{
dat <- data.frame(
  y = c(1.0, NA, 2.3, 0.5),
  x1 = rnorm(4),
  x2 = rnorm(4)
)

## Without cross-fitting
res <- oss_estimator(y ~ x1 + x2, dat)

## With cross-fitting
res_cf <- oss_estimator(y ~ x1 + x2, dat, crossfitting = TRUE)
}
\references{
\insertRef{RisebrowSSLR}{LRMiss}
}
