% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_knockoff.R
\name{create_knockoff}
\alias{create_knockoff}
\title{Create knockoff genotype data}
\usage{
create_knockoff(
  trio.hap = NULL,
  duo.hap = NULL,
  pos,
  M = 10,
  maxcor = 0.7,
  maxbp = 80000,
  phasing.dad = NULL,
  phasing.mom = NULL,
  seed = 100
)
}
\arguments{
\item{trio.hap}{A 6n*p matrix for trio haplotype data, in which n is the number of trios and p is the number of variants. Each trio must consist of father, mother, and offspring (in this order). The haplotypes must be coded as 0 or 1. Missing haplotypes are not allowed.}

\item{duo.hap}{A 4m*p matrix for duo haplotype data, in which m is the number of duos and p is the number of variants. Each duo must consist of a single parent and offspring (in this order). The haplotypes must be coded as 0 or 1. Missing haplotypes are not allowed.}

\item{pos}{A numeric vector of length p for the position of p variants.}

\item{M}{A positive integer for the number of knockoffs. The default is 10.}

\item{maxcor}{A real number in a range of [0,1] for hierarchical clustering of neighboring variants used to generate knockoff parents. The default is 0.7.}

\item{maxbp}{A positive integer for the size of neighboring base pairs used to generate knockoff parents. The default is 80000.}

\item{phasing.dad}{A numeric vector of length n that contains 1 or 2 to indicate which paternal haplotype was transmitted to offspring in each trio. If NULL, the function will calculate the phasing information based on the input trio haplotype matrix.}

\item{phasing.mom}{A numeric vector of length n that contains 1 or 2 to indicate which maternal haplotype was transmitted to offspring in each trio. If NULL, the function will calculate the phasing information based on the input trio haplotype matrix.}

\item{seed}{An integer for the random seed used for knockoff generation.}
}
\value{
A list that contains:
\describe{
  \item{trio.ko}{A 3n*p*M array for knockoff trio genotype data if trio.hap is provided.}
  \item{duo.ko}{A 3m*p*M array for knockoff duo genotype data if duo.hap is provided.}
  \item{duo}{A 3m*p matrix for duo genotype data if duo.hap is provided.}
}
}
\description{
Create knockoff genotype data using phased haplotype data.
}
\examples{
data(KnockoffTrio.example)
knockoff<-create_knockoff(trio.hap=KnockoffTrio.example$trio.hap,
          duo.hap=KnockoffTrio.example$duo.hap, pos=KnockoffTrio.example$pos, M=10)
}
