% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_data.R
\name{show_diff_uptake_data_confidence}
\alias{show_diff_uptake_data_confidence}
\title{Differential uptake data with confidence}
\usage{
show_diff_uptake_data_confidence(
  diff_uptake_dat,
  theoretical = FALSE,
  fractional = FALSE,
  confidence_level = 0.98,
  hybrid = FALSE
)
}
\arguments{
\item{diff_uptake_dat}{data produced by \code{\link{create_diff_uptake_dataset}}
function}

\item{theoretical}{\code{logical}, indicator if values are 
calculated using theoretical controls}

\item{fractional}{\code{logical}, indicator if values are shown 
in fractional form}

\item{confidence_level}{confidence level for the test, from range [0, 1].}

\item{hybrid}{\code{logical}, indicator if the hybrid testing was
applied in diff_uptake_dat.}
}
\value{
a \code{\link{data.frame}} object
}
\description{
Present differential deuterium uptake values 
in selected form, accompanied by the significance
}
\details{
The function \code{\link{show_uptake_data}} generates a subsets
of the uptake dat based on selected parameters. It contains the information
if the value is statistically significant at selected confidence level.
The numerical values are rounded to 4 places. The names of columns
are changed to user-friendly ones.
}
\examples{
diff_uptake_dat <- create_diff_uptake_dataset(alpha_dat)
show_diff_uptake_data_confidence(diff_uptake_dat)

}
\seealso{
\code{\link{create_diff_uptake_dataset}}
\code{\link{plot_differential}}
}
