% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replicates.R
\name{plot_replicate_histogram}
\alias{plot_replicate_histogram}
\title{Plot replicates histogram}
\usage{
plot_replicate_histogram(
  rep_dat,
  time_points = FALSE,
  interactive = getOption("hadex_use_interactive_plots")
)
}
\arguments{
\item{rep_dat}{replicate data, created by 
\code{\link{create_replicate_dataset}} function.}

\item{time_points}{\code{logical}, indicator if the histogram
should show values aggregated for time points of measurements.}

\item{interactive}{\code{logical}, whether plot should have an interactive 
layer created with with ggiraph, which would add tooltips to the plot in an
interactive display (HTML/Markdown documents or shiny app).}
}
\value{
a [ggplot2::ggplot()] object.
}
\description{
Plot histogram on number of replicates per
peptide in one or multiple time point of measurement.
}
\details{
The function shows three versions of replicate 
histogram, based on supplied \code{rep_dat} and \code{time_points}. 
If \code{time_points} is selected, the histogram shows the number 
of replicates for time points of measurement, to spot
if there were troubles with samples for specific time point of
measurement. Then, on the X-axis is Exposure (in minutes) and 
on the Y-axis number of replicates.
If \code{time_points} is not selected, on the X-axis there are 
peptide ID, and on the Y-axis there are numbers of replicates. 
If \code{rep_dat} contains data from one time point 
of measurement, the histogram colors reflect the 
number of replicates to highlight the outliers.
If \code{rep_dat} contains multiple time point of
measurement, the colors help to distinguish between 
them.
}
\examples{
rep_dat <- create_replicate_dataset(alpha_dat)
plot_replicate_histogram(rep_dat)

plot_replicate_histogram(rep_dat, time_points = TRUE)

rep_dat <- create_replicate_dataset(alpha_dat, time_t = 0.167)
plot_replicate_histogram(rep_dat)

}
\seealso{
\code{\link{create_replicate_dataset}} 
\code{\link{show_replicate_histogram_data}}
}
