% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_aggregated_uptake.R
\name{plot_aggregated_uptake}
\alias{plot_aggregated_uptake}
\title{Plots aggregated uptake}
\usage{
plot_aggregated_uptake(
  aggregated_dat,
  fractional = TRUE,
  theoretical = FALSE,
  time_100 = max(unique(aggregated_dat[["Exposure"]])),
  panels = FALSE,
  interactive = FALSE
)
}
\arguments{
\item{aggregated_dat}{aggregated differential 
uptake data as calculated by \code{\link{create_aggregated_uptake_dataset}}}

\item{fractional}{\code{logical}, determines if values are fractional}

\item{theoretical}{\code{logical}, determines if values are theoretical}

\item{time_100}{maximal exchange control time point of measurement [min]}

\item{panels}{\code{logical}, indicator if plot should be divided 
into panels or not}

\item{interactive}{\code{logical}, whether plot should have an interactive 
layer created with with ggiraph, which would add tooltips to the plot in an
interactive display (HTML/Markdown documents or shiny app).}
}
\value{
a \code{\link[ggplot2]{ggplot}} object
}
\description{
Plots aggregated uptake
}
\examples{
\donttest{
# disabled due to long execution time 

kin_dat <- create_uptake_dataset(alpha_dat, states = "Alpha_KSCN")
aggregated_dat <- create_aggregated_uptake_dataset(kin_dat)
plot_aggregated_uptake(aggregated_dat, panels = FALSE)
plot_aggregated_uptake(aggregated_dat, fractional = FALSE, panels = FALSE)
plot_aggregated_uptake(aggregated_dat, fractional = FALSE, theoretical = TRUE, panels = TRUE)
}

}
