% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_p_value.R
\name{calculate_p_value}
\alias{calculate_p_value}
\title{Create p-value dataset}
\usage{
calculate_p_value(
  dat,
  protein = unique(dat[["Protein"]])[1],
  state_1 = unique(dat[["State"]])[1],
  state_2 = unique(dat[["State"]])[2],
  p_adjustment_method = "none",
  confidence_level = 0.98
)
}
\arguments{
\item{dat}{data imported by the \code{\link{read_hdx}} function.}

\item{protein}{chosen protein.}

\item{state_1}{biological state for chosen protein. From this state values
the second state values are subtracted to get the deuterium uptake difference.}

\item{state_2}{biological state for chosen protein. This state values are 
subtracted from the first state values to get the deuterium uptake difference.}

\item{p_adjustment_method}{method of adjustment P-values for multiple 
comparisons. Possible methods: "BH" (Benjamini & Hochberg correction), 
"bonferroni" (Bonferroni correction) and "none" (default).}

\item{confidence_level}{confidence level for the t-test.}
}
\value{
a \code{\link{data.frame}} object.
}
\description{
Create p-value dataset
}
\details{
This function calculates P-value based on the supplied data.
Unpaired t-Student test (with supplied parameters) is used to establish if the 
null hypothesis (there is no difference between measured mass values 
between two selected biological states) can be rejected, based on the 
experimental mass values from replicates of the experiment - for peptide
in given time point of measurement.
For the peptides that have only one replicate of the measurement (in any 
state) the P-value cannot be calculated and is assigned with NA value.
}
\examples{
p_dat <- calculate_p_value(alpha_dat)
head(p_dat)

}
\seealso{
\code{\link{read_hdx}}
\code{\link{calculate_exp_masses_per_replicate}}
\code{\link{plot_volcano}}
\code{\link{create_diff_uptake_dataset}}
\code{\link{create_p_diff_uptake_dataset}}
}
