% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_masses.R
\name{calculate_exp_masses_per_replicate}
\alias{calculate_exp_masses_per_replicate}
\title{Calculate measured mass for each replicate of the 
experiment}
\usage{
calculate_exp_masses_per_replicate(dat)
}
\arguments{
\item{dat}{data as imported by the \code{\link{read_hdx}} function}
}
\value{
a \code{\link{data.frame}} object.
}
\description{
Calculate the measured mass from partial results, per each 
replicate of the experiment.
}
\details{
Each replicate of the experiment generates measurements of the mass 
for obtained charge values for the peptide. This is an effect of the properties
of mass spectrometry, that measures the mass to charge ratio (learn more about 
Mass Spectrometry in the documentation). The possible charge values depend on
the sequence of the peptide.
The separate measurement (for each replicate in given state in given time point)
can be distinguished by the `File` value.
}
\examples{
head(calculate_exp_masses_per_replicate(alpha_dat))

}
\seealso{
\code{\link{read_hdx}} 
\code{\link{calculate_exp_masses}}
\code{\link{calculate_state_uptake}}
}
