\name{gsom_updateCategorical}
\alias{gsom_updateCategorical}
\title{Update categorical prototype in Gower-SOM (internal)}
\description{
Updates the categorical prototype of a neuron given candidate factor
levels and associated weights.
}
\details{
If \code{sampling = FALSE}, the function returns the weighted mode
(i.e., the most probable level according to weights).
If \code{sampling = TRUE}, it samples one level with probability
proportional to the normalized weights, introducing stochasticity.
}
\usage{
gsom_updateCategorical(values, weights, sampling = FALSE)
}
\arguments{
  \item{values}{A factor vector of candidate categories.}
  \item{weights}{A numeric vector of weights, same length as \code{values}.}
  \item{sampling}{Logical; if \code{TRUE} sample proportionally,
    else take weighted mode.}
}
\value{
A factor of length 1 with the chosen level.
}

\author{
  Patricio Sáez <patricsaez@udec.cl>;
  Patricio Salas <patricioasalas@udec.cl>
}

\references{
Sáez, P., Salas, P. Gower-SOM: a self-organizing map for mixed data with gower distance and heuristic adaptation for data analytics. Int J Data Sci Anal 22, 26 (2026). https://doi.org/10.1007/s41060-025-00941-6/."
}
\examples{
vals <- factor(c("A","A","B","C"))
wts  <- c(0.2, 0.5, 0.2, 0.1)

# Deterministic update (weighted mode)
gsom_updateCategorical(vals, wts, sampling = FALSE)

# Stochastic update (weighted sampling)
gsom_updateCategorical(vals, wts, sampling = TRUE)
}
\keyword{internal}
