% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2025-10-27_JF_R_Galaxy_functions.R
\name{galaxy_get_file_info}
\alias{galaxy_get_file_info}
\title{Get information for one or more Galaxy datasets}
\usage{
galaxy_get_file_info(file_ids, galaxy_url = "https://usegalaxy.eu")
}
\arguments{
\item{file_ids}{Character vector of Galaxy dataset IDs.}

\item{galaxy_url}{Character. Base URL of the Galaxy instance
(for example \code{"https://usegalaxy.eu"}).
If the environment variable \code{GALAXY_URL} is set, it takes precedence.}
}
\value{
A data.frame with one row per dataset and the columns:
\code{id}, \code{name}, \code{size_bytes}, \code{human_size},
\code{file_type}, \code{state}, \code{deleted}.
}
\description{
Retrieves metadata for one or more Galaxy history datasets (HDAs),
including name, size, type, state, and deletion status.
}
\details{
This function queries the \code{/api/datasets/{id}} endpoint for each
provided dataset ID. If a dataset cannot be retrieved, its fields
are returned as \code{NA}.
}
\examples{
\dontshow{if (nzchar(Sys.getenv("GALAXY_API_KEY"))) withAutoprint(\{ # examplesIf}
tmp_dir <- tempdir()
f_name <- "iris.csv"
f_path <- paste(tmp_dir, f_name, sep = "\\\\")
write.csv(datasets::iris, f_path, row.names = FALSE)

history_id <- galaxy_initialize("IRIS")
file_id <- galaxy_upload_https(f_path, history_id)
galaxy_get_file_info(file_id)
\dontshow{\}) # examplesIf}
}
