% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glme.gev11.R
\name{init.glme.gev11}
\alias{init.glme.gev11}
\title{Initialize parameters for multi-start GEV11 optimization}
\usage{
init.glme.gev11(data, ntry = 10, pretheta = NULL)
}
\arguments{
\item{data}{Numeric vector of data.}

\item{ntry}{Number of initial parameter sets to generate. Default is 10.}

\item{pretheta}{Pre-estimated parameter vector (mu0, mu1, sigma0, sigma1, xi).}
}
\value{
A matrix with \code{ntry} rows and 3 columns (mu0, log(sigma), xi).
}
\description{
Internal function that generates initial parameter sets
(mu0, sigma0, xi) for multi-start optimization in the GEV11 model.
Uses stationary L-moment estimates and random perturbations.
}
\keyword{internal}
