% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glme.gev.R
\name{glme.gev}
\alias{glme.gev}
\title{Generalized L-moments estimation for generalized extreme value distribution}
\usage{
glme.gev(
  xdat,
  ntry = 10,
  pen = "beta",
  pen.choice = NULL,
  mu = -0.5,
  std = 0.2,
  p = 6,
  c1 = 10,
  c2 = 5
)
}
\arguments{
\item{xdat}{A numeric vector of data to be fitted.}

\item{ntry}{Number of attempts for parameter estimation. Higher values increase
the chance of finding a more accurate estimate by trying different initial conditions.}

\item{pen}{Type of penalty function: Choose among "norm", "beta" (default),
"ms", "park", "cannon", "cd", and "no" (without penalty function).}

\item{pen.choice}{Choice number of penalty function specifying hyperparameters.
For "beta": 1-6 correspond to different (p, c1, c2) combinations.
For "norm": 1-4 correspond to different (mu, std) combinations.}

\item{mu}{Mean hyperparameter for "norm" penalty function (default -0.5).}

\item{std}{Standard deviation hyperparameter for "norm" penalty function (default 0.2).}

\item{p}{Shape hyperparameter for "beta" penalty function (default 6).}

\item{c1}{Scaling hyperparameter for "beta" penalty function (default 10).}

\item{c2}{Upper limit hyperparameter for "beta" penalty function (default 5).}
}
\value{
The glme.gev function returns a list containing the following elements:
\itemize{
 \item para.glme - The estimated parameters of the Generalized Extreme Value distribution.
 \item para.lme - The L-moment estimates of the parameters.
 \item covinv.lmom - The inverse of the covariance matrix of the L-moments.
 \item lcovdet - The log determinant of the covariance matrix.
 \item nllh.glme - The negative log-likelihood of the GLME solution.
 \item pen - The penalization method used.
 \item p_q - (for beta penalty) The p and q values used.
 \item c1_c2 - (for beta penalty) The c1 and c2 values used.
 \item mu_std - (for norm penalty) The mu and std values used.
}
}
\description{
This function estimates the Generalized L-moments of Generalized Extreme Value distribution.
}
\details{
The equations for the L-moments for LME of the GEVD are
\deqn{ \underline{\bf \lambda} - \underline{\bf l} = \underline{\bf 0},}
where \eqn{ \underline{\bf \lambda} =(\lambda_1,\; \lambda_2,\; \lambda_3)^t } and \eqn{\underline{\bf l} =(l_1,\; l_2,\; l_3)^t}.
Next, we define the generalized L-moments distance (GLD) as;
\deqn{(\underline{\bf \lambda} -\underline{\bf l})^t V^{-1} (\underline{\bf \lambda} -\underline{\bf l}),}
where \eqn{V} is the variance-covariance matrix of the sample L-moments up to the third order.
}
\examples{
# Load example streamflow data
data(streamflow)
x <- streamflow$r1

# Estimate GEV parameters using beta penalty (default)
result <- glme.gev(x, ntry = 5)
print(result$para.glme)

# Using Martins-Stedinger penalty
result_ms <- glme.gev(x, ntry = 5, pen = "ms")
print(result_ms$para.glme)

}
\references{
Shin, Y., Shin, Y., Park, J. & Park, J.-S. (2025). Generalized method of
L-moment estimation for stationary and nonstationary extreme value models.
arXiv preprint arXiv:2512.20385. \doi{10.48550/arXiv.2512.20385}
}
\seealso{
\code{\link{glme.gev11}} for non-stationary GEV estimation,
  \code{\link{ma.gev}} for model averaging estimation,
  \code{\link{glme.like}} for the objective function,
  \code{\link{quagev.NS}} for quantile computation.
}
\author{
Yonggwan Shin, Seokkap Ko, Jihong Park, Yire Shin, Jeong-Soo Park
}
