% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/magev_helpers.R
\name{cand.xi}
\alias{cand.xi}
\title{Select candidate shape parameter values for model averaging}
\usage{
cand.xi(
  data,
  hosking = NULL,
  mle = NULL,
  pick0 = 0.95,
  nint = 256,
  start = "mle",
  numk = NULL,
  figure = TRUE,
  cov.lme = NULL,
  bma = FALSE,
  pen = "beta"
)
}
\arguments{
\item{data}{Numeric vector of data.}

\item{hosking}{List containing LME results and bootstrap information.}

\item{mle}{MLE parameter estimates (mu, sigma, xi) in Hosking style.}

\item{pick0}{Confidence level for the profile CI. Default is 0.95.}

\item{nint}{Number of points for profile likelihood evaluation. Default is 256.}

\item{start}{Starting method: "mle" (default), "lme", or "mix".}

\item{numk}{Number of candidate submodels.}

\item{figure}{Logical. Whether to produce a profile likelihood plot (default TRUE).}

\item{cov.lme}{Pre-computed LME covariance (default NULL).}

\item{bma}{Logical. Whether BMA is being used (default FALSE).}

\item{pen}{BMA prior type (default "beta").}
}
\value{
A list containing:
\describe{
  \item{kpar}{Numeric vector of K candidate xi values}
  \item{start}{Starting method actually used}
  \item{get.ci}{Profile CI result (if start="mle")}
  \item{ymin}{Minimum y value for plotting (if start="mle")}
}
}
\description{
Internal function that selects K candidate shape parameter
(xi) values from the profile likelihood confidence interval. Falls back
to bootstrap LME quantiles if the profile likelihood fails.
}
\keyword{internal}
