% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gareg_subset.R
\name{subsetBIC}
\alias{subsetBIC}
\title{Unified BIC-style Objective for Subset Selection (GLM & Gaussian)}
\usage{
subsetBIC(
  subset_bin,
  y,
  X,
  family = stats::gaussian(),
  weights = NULL,
  offset = NULL,
  control = stats::glm.control()
)
}
\arguments{
\item{subset_bin}{Integer/numeric 0–1 vector (length \code{ncol(X)}); 1 means
the corresponding column of \code{X} is included in the model.}

\item{y}{Numeric response vector of length \code{n}.}

\item{X}{Numeric matrix of candidate predictors; columns correspond to variables.}

\item{family}{A GLM family object (default \code{stats::gaussian()}).}

\item{weights}{Optional prior weights (passed to \code{glm.fit}).}

\item{offset}{Optional offset (passed to \code{glm.fit}).}

\item{control}{GLM fit controls; default \code{stats::glm.control()}.}
}
\value{
A single numeric value: \strong{-BIC}. Larger is better for GA maximizers.
  Returns \code{Inf} for rank-deficient designs.
}
\description{
Computes a BIC-like criterion for a chromosome that encodes a variable
subset. The same expression
\deqn{\mathrm{BIC} = n \log(\mathrm{rss\_like}/n) + k \log n}
is used for all families, where:
\itemize{
  \item For Gaussian with identity link, \code{rss_like} is the residual sum of squares (RSS),
        computed via a fast \code{.lm.fit}.
  \item For other GLM families, \code{rss_like} is the residual \emph{deviance}
        from \code{glm.fit}.
}
The effective parameter count \eqn{k} includes the intercept.
}
\details{
The chromosome \code{subset_bin} is a \emph{binary} vector (0/1 by column),
indicating which predictors from \code{X} are included. The design matrix
always includes an intercept. Rank-deficient selections return \code{Inf}
(which the GA maximizer treats as a very poor score). The value returned is
\strong{-BIC} so that GA engines can \emph{maximize} it.
}
\seealso{
\code{\link[stats]{glm.fit}}, \code{\link[stats]{glm.control}},
  \code{\link[stats]{.lm.fit}}
}
