% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forecast_util_functions.R
\name{loss.diff.p}
\alias{loss.diff.p}
\title{Loss differential from two point forecasts}
\usage{
loss.diff.p(y, f1, f2, type = "quad", ...)
}
\arguments{
\item{y}{actual value, \eqn{y_{t}}{y(t)}, for \eqn{t=1,2,...,T}.}

\item{f1}{point forecast 1, \eqn{f_{1,t}}{f1(t)}, for \eqn{t=1,2,...,T}.}

\item{f2}{point forecast 2, \eqn{f_{2,t}}{f2(t)}, for \eqn{t=1,2,...,T}.}

\item{type}{Type of loss functions to compare.
\itemize{
\item "quad" : quadratic loss function (default)
\item "abs"  : absolute loss function
\item "check" : check (quantile) loss function
\item "linex" : linex loss function
}}

\item{...}{Extra parameters to compute loss function.
\itemize{
\item For type="quad"  : no extra parameter is needed.
\item For type="abs"   : no extra parameter is needed.
\item For type="check" : a scalar parameter (tau) is needed. tau \eqn{\in [0,1]}{in [0,1]}. Default value is tau=0.5 if unspecified.
\item For type="linex" : a scalar parameter (c) is needed. c is a real number. Default value is c=1.
}}
}
\value{
This function returns a sequence of the loss differential, \eqn{d_{t}}{d(t)}.
}
\description{
This function computes the loss differential from two point forecasts. Let \eqn{f_{1,t}}{f1(t)} and \eqn{f_{2,t}}{f2(t)}
be point forecasts generated by the forecaster 1 (e.g., forecasting model 1) and the forecaster 2 (e.g., forecasting model 2), respectively.
\eqn{y_{t}}{y(t)} is a forecasting target that both \eqn{f_{1,t}}{f1(t)} and \eqn{f_{2,t}}{f2(t)} try to forecast.
For a given loss function the loss differential is defined and computed as
\deqn{d_{t} = L(y_{t}, f_{1,t}) - L(y_{t}, f_{2,t})}{d(t) = L(y(t), f1(t)) - L(y(t), f2(t))}
for \eqn{t=1,2,...,T}.
}
\details{
Type of loss functions. Define \eqn{e_{t} = y_{t}-f_{t}}{e(t)=y(t)-f(t)}.
Quadratic loss function is defined as
\deqn{L(y_{t}, f_{t}) = e_{t}^2}{L(y(t), f(t)) = e(t)^2}
Absolute loss function is defined as
\deqn{L(y_{t}, f_{t}) = |e_{t}|}{L(y(t), f(t)) = |e(t)|}
Check loss function is defined as
\deqn{L(y_{t}, f_{t}) = (\tau - 1(e_{t}<0))e_{t}}{L(y(t) f(t)) = (tau - 1(e(t)<0))e(t)}
Linex loss function is defined as
\deqn{L(y_{t}, f_{t}) = \exp(c e_{t}) - c e_{t} - 1}{L(y(t), f(t)) = exp(ce(t)) - ce(t) - 1}
If c is positive (negative) real number, then the linex function is exponential (linear) for e>0 and linear (exponential) for e<0.

A sample average of the returned sequence, \eqn{\bar{d}_{t} = \frac{1}{T}\sum_{t=1}^{T}d_{t}}{dbar}, is the difference in average loss from forecaster 1 and forecaster 2.
Positive \eqn{\bar{d}_{t}}{dbar} means that the forecaster 2 incurs lower expected loss compared to the forecaster 1.
Negative \eqn{\bar{d}_{t}}{dbar} means that the forecaster 1 incurs lower expected loss compared to the forecaster 2.
Statistical testing to test whether the loss differential is zero in expectation is possible. See, for example, \link[ForeComp]{dm.test.r}.
}
\author{
Minchul Shin
}
