% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performance.R
\name{Local_Struct}
\alias{Local_Struct}
\title{Local structure preservation metric}
\usage{
Local_Struct(
  SS2,
  tenx,
  integrated,
  dims = 30,
  emb_key = "pca",
  batch_key = "dataset",
  neighbors = 20
)
}
\arguments{
\item{SS2, tenx}{\link[Seurat]{Seurat} objects containing the **unintegrated**
PCA reduction (slot \code{reductions$pca}).}

\item{integrated}{\link[Seurat]{Seurat} object that contains the **joint**
PCA reduction and a meta-data column \code{dataset}.}

\item{dims}{Number of principal components to use (default 30).}

\item{emb_key}{Name of the reduction to use (default \code{"pca"}).}

\item{batch_key}{Name of the meta-data column that indicates dataset/batch
origin (default \code{"dataset"}).}

\item{neighbors}{Size of the neighbourhood to evaluate (default 20).}
}
\value{
A named list with two numeric vectors:
\item{SS2}{Per-cell overlap scores for the SS2 dataset.}
\item{tenx}{Per-cell overlap scores for the 10X dataset.}
}
\description{
Compute the neighbourhood overlap between the original PCA space of each
dataset and the integrated PCA space, averaged over the top \code{neighbors}
nearest neighbours.  High overlap indicates better local structure
preservation after integration.
}
