% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExpressionCellNet.R
\name{createExpCellNetObj}
\alias{createExpCellNetObj}
\title{Create an ExpressionCellNet object}
\usage{
createExpCellNetObj(count_matrix, annotations, intraction_db)
}
\arguments{
\item{count_matrix}{A gene-by-sample expression count matrix (rows: genes, cols: samples).}

\item{annotations}{A data.frame containing gene annotations/mapping information.}

\item{intraction_db}{A data.frame of gene-gene interactions (two columns).}
}
\value{
An ExpressionCellNet object (list) containing core data components.
}
\description{
Wraps the core inputs (count matrix, annotation table, and interaction database)
into a single ExpressionCellNet object used by downstream functions.
}
\examples{

data("example_data")
obj <- createExpCellNetObj(
   count_matrix  = example_data$counts,
   annotations   = example_data$annot_df,
   intraction_db = example_data$interactions
)

}
