% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExpressionCellNet.R
\name{ShowPathway}
\alias{ShowPathway}
\title{Visualize a pathway (highlighted subgraph)}
\usage{
ShowPathway(ExpCellNetObj, Pathway)
}
\arguments{
\item{ExpCellNetObj}{An ExpressionCellNet object containing a constructed network.}

\item{Pathway}{A character vector of genes representing a path (e.g., output of FindPathway()).}
}
\value{
A plot (igraph/base) is produced as a side effect.
}
\description{
Highlights the nodes/edges of a provided pathway on the full network visualization.
}
\examples{

data("example_data")
p <- FindPathway(example_data$expcellnetobj, Start_gene="Gene1", End_gene="Gene11")
ShowPathway(example_data$expcellnetobj, Pathway = p)


}
