% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExpressionCellNet.R
\name{NetworkPrediction}
\alias{NetworkPrediction}
\title{Predict network-wide expression changes after perturbing a seed gene}
\usage{
NetworkPrediction(ExpCellNetObj, Gene, Expression)
}
\arguments{
\item{ExpCellNetObj}{An ExpressionCellNet object.}

\item{Gene}{Character; seed gene to perturb.}

\item{Expression}{Numeric; imposed expression value under perturbation.}
}
\value{
Updated ExpressionCellNet object with regression models and results.
}
\description{
Fits linear regression models for seed-to-network genes and predicts shifts under a user-defined
perturbation scenario. Stores multiple result components in the object.
}
\examples{

data("example_data")
obj <- NetworkPrediction(example_data$expcellnetobj, Gene="Gene1", Expression=0)

}
