% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExpressionCellNet.R
\name{FindPathway}
\alias{FindPathway}
\title{Find the shortest path between two genes in the network}
\usage{
FindPathway(ExpCellNetObj, Start_gene, End_gene)
}
\arguments{
\item{ExpCellNetObj}{An ExpressionCellNet object containing a constructed network.}

\item{Start_gene}{Character; source gene symbol (must exist as a node in the network).}

\item{End_gene}{Character; destination gene symbol (must exist as a node in the network).}
}
\value{
A character vector of gene symbols representing the shortest path.
}
\description{
Computes the shortest interaction path (as a sequence of gene names) between a
start gene and an end gene using the network stored in the ExpressionCellNet object.
}
\examples{

data("example_data")
path <- FindPathway(example_data$expcellnetobj, Start_gene="Gene1", End_gene="Gene11")
path

}
