% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExpressionCellNet.R
\name{CountMatrixNormalization}
\alias{CountMatrixNormalization}
\title{Normalize expression count matrix}
\usage{
CountMatrixNormalization(
  ExpCellNetObj,
  CheckExpression = TRUE,
  CPM = TRUE,
  LogTransform = FALSE
)
}
\arguments{
\item{ExpCellNetObj}{An ExpressionCellNet object.}

\item{CheckExpression}{Logical; if TRUE, low-expression genes are filtered.}

\item{CPM}{Logical; if TRUE, counts are converted to counts-per-million.}

\item{LogTransform}{Logical; if TRUE, log2 transform is applied (typically after CPM).}
}
\value{
Updated ExpressionCellNet object containing normalized matrix.
}
\description{
Filters low-expression genes (optional), applies CPM normalization (optional),
and log2 transformation (optional). Stores results inside the ExpressionCellNet object.
}
\examples{

data("example_data")
obj <- CountMatrixNormalization(
    example_data$expcellnetobj,
    CheckExpression = TRUE,
    CPM = TRUE,
    LogTransform = TRUE
)


}
