% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExpressionCellNet.R
\name{BuildNetwork}
\alias{BuildNetwork}
\title{Construct a gene interaction network centered on a seed gene}
\usage{
BuildNetwork(
  ExpCellNetObj,
  Gene = "Gene1",
  Generation = 3,
  CorrelationThreshold = c(0.7, 0.7, 0.7)
)
}
\arguments{
\item{ExpCellNetObj}{An ExpressionCellNet object containing expression and interaction data.}

\item{Gene}{Character; seed gene name (generation 0).}

\item{Generation}{Integer; number of generations to expand from the seed gene.}

\item{CorrelationThreshold}{Numeric vector; per-generation correlation thresholds.}
}
\value{
Updated ExpressionCellNet object with added components such as "Network" and "Generations".
}
\description{
Builds a multi-generation network starting from a seed gene using curated interactions
and correlation filtering across generations.
}
\examples{

data("example_data")
obj <- BuildNetwork(
    example_data$expcellnetobj,
    Gene = "Gene1",
    Generation = 3,
    CorrelationThreshold = c(0.65, 0.70, 0.75)
)


}
