#' Example dataset for ExpressionCellNet
#'
#' Simulated example dataset containing four objects:
#' \code{counts}, \code{annot_df}, \code{interactions}, and \code{expcellnetobj}.
#' All data are mock / artificial for testing.
#'
#' @docType data
#' @usage data(example_data)
#' @format An RData file containing:
#' \describe{
#'   \item{counts}{Numeric matrix of simulated RNA-seq counts.}
#'   \item{annot_df}{Data frame with ENSEMBL IDs and Gene Symbols.}
#'   \item{interactions}{Data frame representing gene–gene interactions.}
#'   \item{expcellnetobj}{Example ExpressionCellNet object.}
#' }
#' @keywords datasets
"example_data"
