test_that("limits are correct with no ouliers", {
  x <- SimulateAnomalies(100, 0, 10)
  elNames <- c("nRec", "nonMiss", "loLim", "upLim")
  val <- ComputeOutlierLimits(x, "T")
  xpct <- c(100, 100, -1.758272, 1.758272)
  names(xpct) <- elNames
  expect_equal(round(val, digits = 5), round(xpct, digits = 5))
  val <- ComputeOutlierLimits(x, "H")
  xpct <- c(100, 100, -2.246364, 2.246364)
  names(xpct) <- elNames
  expect_equal(round(val, digits = 5), round(xpct, digits = 5))
  val <- ComputeOutlierLimits(x, "B")
  xpct <- c(100, 100, -2.0, 2.0)
  names(xpct) <- elNames
  expect_equal(round(val, digits = 5), round(xpct, digits = 5))
})
test_that("limits are correct with one oulier", {
  x <- SimulateAnomalies(100, 1, 10)
  elNames <- c("nRec", "nonMiss", "loLim", "upLim")
  val <- ComputeOutlierLimits(x, "T")
  xpct <- c(100, 100, -3.351433, 3.571433)
  names(xpct) <- elNames
  expect_equal(round(val, digits = 5), round(xpct, digits = 5))
  val <- ComputeOutlierLimits(x, "H")
  xpct <- c(100, 100, -2.226162, 2.266566)
  names(xpct) <- elNames
  expect_equal(round(val, digits = 5), round(xpct, digits = 5))
  val <- ComputeOutlierLimits(x, "B")
  xpct <- c(100, 100, -1.979798, 2.020202)
  names(xpct) <- elNames
  expect_equal(round(val, digits = 5), round(xpct, digits = 5))
})
test_that("limits are correct with missing data", {
  x <- SimulateAnomalies(100, 1, 10)
  x[91:100] <- NA
  elNames <- c("nRec", "nonMiss", "loLim", "upLim")
  val <- ComputeOutlierLimits(x, "T")
  xpct <- c(100, 90, -3.529406, 3.571830)
  names(xpct) <- elNames
  expect_equal(round(val, digits = 5), round(xpct, digits = 5))
  val <- ComputeOutlierLimits(x, "H")
  xpct <- c(100, 90, -2.102535, 1.940919)
  names(xpct) <- elNames
  expect_equal(round(val, digits = 5), round(xpct, digits = 5))
  val <- ComputeOutlierLimits(x, "B")
  xpct <- c(100, 90, -1.878788, 1.717172)
  names(xpct) <- elNames
  expect_equal(round(val, digits = 5), round(xpct, digits = 5))
})
