% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_dataframe.R
\name{export_dataframe}
\alias{export_dataframe}
\title{Export R dataframe as an \code{EViews} workfile}
\usage{
export_dataframe(
  source_description = "",
  wf = "",
  start_date = "",
  frequency = "",
  save_path = ""
)
}
\arguments{
\item{source_description}{Description of the file from which the data is to be imported. The specification of the description is usually just the path and file name of the file.}

\item{wf}{Object or a character string representing the name of a workfile to be created}

\item{start_date}{Object or a character string representing the \code{start date}. It should be left blank for undated (when the \code{frequency} is \code{u}).}

\item{frequency}{Object or a character string representing the frequency of a workfile page to be created. Only letters accepted by EViews are allowed. For example \code{u} for undated, \code{a} for annual, \code{m} for monthly and so on.}

\item{save_path}{Specify where to save the \code{EViews} workfile.}
}
\value{
An EViews workfile.
}
\description{
Use this function in R, R Markdown and Quarto to export an R dataframe as an \code{EViews} workfile
}
\examples{
library(EviewsR)
\dontrun{

Data=data.frame(x=cumsum(rnorm(100)),y=cumsum(rnorm(100)))

export_dataframe(wf="export_dataframe",source_description=Data,start_date = '1990',frequency = "m")
}
}
\seealso{
Other important functions: 
\code{\link{EviewsR-package}},
\code{\link{create_object}()},
\code{\link{eng_eviews}()},
\code{\link{eviews_graph}()},
\code{\link{eviews_import}()},
\code{\link{eviews_pagesave}()},
\code{\link{eviews_wfcreate}()},
\code{\link{eviews_wfsave}()},
\code{\link{exec_commands}()},
\code{\link{export}()},
\code{\link{import}()},
\code{\link{import_equation}()},
\code{\link{import_graph}()},
\code{\link{import_kable}()},
\code{\link{import_series}()},
\code{\link{import_table}()},
\code{\link{import_workfile}()},
\code{\link{rwalk}()},
\code{\link{set_eviews_path}()}
}
\concept{important functions}
\keyword{documentation}
