

\name{emxVARMAModel}
\alias{emxVARMAModel}
\alias{emxModelVARMA}
\alias{emxARMAModel}
\alias{emxModelARMA}

\title{Create a latent (vector) autoregressive moving average (ARMA) model}

\description{
These functions create a vector autoregressive moving average (ARMA) model as an MxModel object.
}

\usage{
emxVARMAModel(model, data, name, run=FALSE, use=colnames(data))
emxModelVARMA(model, data, name, run=FALSE, use=colnames(data))
emxARMAModel(model, data, name, run=FALSE, use=colnames(data))
emxModelARMA(model, data, name, run=FALSE, use=colnames(data))
}


\arguments{
   \item{model}{numeric vector.  The AR lag, followed by the MA lag.}
   \item{data}{data used for the model}
   \item{name}{character.  Optional name of the model created.}
   \item{run}{logical. Whether to run the model before returning.}
   \item{use}{character vector.  The names of the variables to use.}
}

\details{
The purpose of this function is to quickly specify a (vector)
autoregressive moving average model.  The \code{emxARMA} function is
only suitable for univariate processes, but the \code{emxVARMA} function
is suitable for univariate and multivariate processes.  Both functions
create state space models and are fit with full information maximum
likelihood, allowing missing data under a "missing at random"
assumption.  The ARMA models use the state space representation from
Harvery; whereas the VARMA models use the state space representation
from Hamilton.

These functions are the analysis of time series from a single unit of
analysis (e.g., single-subject data).  For multiple units of analysis, combine
these functions with \code{\link{emxModelByID}}.

% The \code{data} argument can be a list of \code{data.frame} objects with one element for each \code{ID}, or a single \code{data.frame} with an \code{ID} variable that separates groups.

% When there are multiple IDs
}

\value{
    An MxModel.
}

\seealso{
\link{emxStateSpaceMixtureModel} , \link{emxModelByID}, \link{emxFactorModel}
}
% \link{emxStateSpaceModel}

%\references{
%
%}

\examples{
   
# Example
require(EasyMx)
data(myFADataRaw)
ds0 <- myFADataRaw[,1:3]

# Make a VARMA(1, 0) Model
vm <- emxVARMAModel(model=c(1, 0), data=ds0, use=names(ds0), name='varmodel')
}
