% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_data_entity_checksum.R
\name{read_data_entity_checksum}
\alias{read_data_entity_checksum}
\title{Read data entity checksum}
\usage{
read_data_entity_checksum(packageId, entityId, env = "production")
}
\arguments{
\item{packageId}{(character) Data package identifier}

\item{entityId}{(character) Data entity identifier}

\item{env}{(character) Repository environment. Can be: "production",
"staging", or "development".}
}
\value{
(character) A 40-character SHA-1 checksum value of \code{entityId}
in \code{packageId}
}
\description{
Read data entity checksum
}
\examples{
\dontrun{

# List data entities
entityIds <- list_data_entities(packageId = "knb-lter-ble.1.7")
entityIds
#> [1] "a1723e0e5f3c4881f1a7ede1b036aba6"
#> [2] "b698644419ea88ab1072f4fcbef9083c"
#> [3] "617415426847fd900b644283d86c1c66"
#> [4] "9942544de7e794ce84a62151bd41e6b3"

# Read checksum
checksum <- read_data_entity_checksum(
 packageId = "knb-lter-ble.1.7",
 entityId = entityIds[1]
)
checksum
#> [1] "22b189095bc9a166c3891e80b67b2a636eae60a4"
}
}
\seealso{
Other Accessing: 
\code{\link{read_data_entity}()},
\code{\link{read_data_entity_name}()},
\code{\link{read_data_entity_names}()},
\code{\link{read_data_entity_resource_metadata}()},
\code{\link{read_data_entity_size}()},
\code{\link{read_data_entity_sizes}()},
\code{\link{read_data_package}()},
\code{\link{read_data_package_archive}()},
\code{\link{read_data_package_citation}()},
\code{\link{read_data_package_doi}()},
\code{\link{read_data_package_error}()},
\code{\link{read_data_package_from_doi}()},
\code{\link{read_data_package_report}()},
\code{\link{read_data_package_report_checksum}()},
\code{\link{read_data_package_report_resource_metadata}()},
\code{\link{read_data_package_report_summary}()},
\code{\link{read_data_package_resource_metadata}()},
\code{\link{read_evaluate_report}()},
\code{\link{read_evaluate_report_summary}()},
\code{\link{read_metadata}()},
\code{\link{read_metadata_checksum}()},
\code{\link{read_metadata_dublin_core}()},
\code{\link{read_metadata_entity}()},
\code{\link{read_metadata_format}()},
\code{\link{read_metadata_resource_metadata}()}
}
\concept{Accessing}
