% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotAsColor.R
\name{plotAsColor}
\alias{plotAsColor}
\title{Function that plots a matrix as a color image}
\usage{
plotAsColor(
  m,
  order = NULL,
  order.col = order,
  order.row = order,
  rank = FALSE,
  border.color = "grey70",
  labels = FALSE,
  x = 1:ncol(d),
  y = 1:nrow(d),
  ...
)
}
\arguments{
\item{m}{Numeric matrix.}

\item{order}{Default order used for rows and columns.}

\item{order.col}{Column order.}

\item{order.row}{Row order}

\item{rank}{Logical, whether matrix m should be converted to ranks or not.}

\item{border.color}{Color of border. Null for no border.}

\item{labels}{If TRUE, add labels obtained from m.}

\item{x}{X coordinates, passed to \code{image}.}

\item{y}{Y coordinates, passed to \code{image}.}

\item{\dots}{passed to \code{image}.}
}
\description{
Function that plots a matrix as a color image, in matrix order.
}
\examples{

	 			

d<- dist(scale(iris[,-5]))
plotAsColor(d,dser(d,hmethod="average"))


}
\seealso{
See Also as \code{\link{image}}.
}
