% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forest_inventory.R
\name{forest_inventory}
\alias{forest_inventory}
\title{Function to perform a forest inventory based on a segmented las object (needs to contain TreeID)}
\usage{
forest_inventory(
  las,
  slice_min = 0.3,
  slice_max = 4,
  increment = 0.2,
  width = 0.1,
  max_dbh = 1,
  n_cores = 1,
  tree_id_col = "TreeID",
  non_tree_id = 0,
  use_stem_segmentation = FALSE,
  semantic_colname = NULL,
  stem_semantic_label = NULL
)
}
\arguments{
\item{las}{lidR las object with the segmented trees}

\item{slice_min}{the minimum height of a slice for stems to estimate the taper curve}

\item{slice_max}{the maximum height of a slice for stems to estimate the taper curve}

\item{increment}{the increment of the slices}

\item{width}{the width of the slices}

\item{max_dbh}{the maximum DBH allowed}

\item{n_cores}{number of cores to use}

\item{tree_id_col}{Column name for the instance segmantation ID (TreeIDs)}

\item{non_tree_id}{tree_id_col value for non tree elements (can be a vector of IDs)}

\item{use_stem_segmentation}{logical whether to use only points classified as stem for DBH estimation}

\item{semantic_colname}{character name of the semantic segmentation column (only needed if use_stem_segmentation is TRUE)}

\item{stem_semantic_label}{integer semantic label value for stem points (only needed if use_stem_segmentation is TRUE)}
}
\value{
a data.frame with the TreeID, X, Y, DBH, quality_flag, Height and ConvexHullArea
}
\description{
This function estimates a taper curve for evry tree and returns the DBH at 1.3m, its position in XY coordinates, the tree height and the trees 2D projection area.
}
\examples{
\donttest{
# read example data
file = system.file("extdata", "beech.las", package="CspStandSegmentation")
las = lidR::readTLSLAS(file)

# find tree positions as starting points for segmentation
map <- CspStandSegmentation::find_base_coordinates_raster(las)

# segment trees
segmented <- las |>
  CspStandSegmentation::add_geometry(n_cores = 2) |>
  CspStandSegmentation::csp_cost_segmentation(map, 1, N_cores = 2)

# perform inventory
inventory <- CspStandSegmentation::forest_inventory(segmented, n_cores = 2)
}
}
