% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PPC_u.R
\name{PPC_u}
\alias{PPC_u}
\title{Projection-on-Complement PCA (Generalized)}
\usage{
PPC_u(data, m, u)
}
\arguments{
\item{data}{A matrix or data frame of input data (n x p).}

\item{m}{Integer. Number of principal components to retain.}

\item{u}{Numeric vector of length n. The projection direction to be removed from the data.
Will be normalized internally.}
}
\value{
A list containing:
\item{Apro}{Estimated factor loading matrix (p x m).}
\item{Dpro}{Estimated residual variances (p x p diagonal matrix).}
\item{Sigmahatpro}{Covariance matrix of the projected data.}
\item{u}{The normalized projection vector used.}
}
\description{
Projects the data onto the orthogonal complement of a given vector \code{u}, eliminating the
effect of \code{u}, and then performs PCA on the projected data. This is useful for removing
specific trends (e.g., time trends, common market factors) before analysis.
}
\examples{
# Examples should be fast and reproducible for CRAN checks
set.seed(123)
dat <- matrix(stats::rnorm(200), ncol = 4)
u0 <- seq_len(nrow(dat))     # e.g., a linear trend to remove
res <- PPC_u(data = dat, m = 2, u = u0)
res$u
head(res$Apro)
}
