% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ovc-munic.R
\encoding{UTF-8}
\name{catr_ovc_get_cod_munic}
\alias{catr_ovc_get_cod_munic}
\title{OVCCallejero: Extract the code of a municipality}
\usage{
catr_ovc_get_cod_munic(cpro, cmun = NULL, cmun_ine = NULL, verbose = FALSE)
}
\arguments{
\item{cpro}{The code of a province, as provided by
\code{\link[=catr_ovc_get_cod_provinces]{catr_ovc_get_cod_provinces()}}.}

\item{cmun, cmun_ine}{Code of a municipality, as recorded on the Spanish
Cadastre (\code{cmun}) or the National Statistics Institute. Either \code{cmun} or
\code{cmun_ine} should be provided.}

\item{verbose}{logical. If \code{TRUE} displays informational messages.}
}
\value{
A \link[tibble:tbl_df-class]{tibble}. See \strong{Details}
}
\description{
Implementation of the OVCCallejero service
\href{https://ovc.catastro.meh.es/ovcservweb/ovcswlocalizacionrc/ovccallejerocodigos.asmx?op=ConsultaMunicipioCodigos}{ConsultaMunicipioCodigos}.

Returns the names and codes of a municipality. Returns both the codes as per
the Cadastre and as per the INE (National Statistics Institute).
}
\details{
On a successful query, the function returns a \link[tibble:tbl_df-class]{tibble}
with one row including the following columns:
\itemize{
\item \code{munic}: Name of the municipality as per the Cadastre.
\item \code{catr_to}: Cadastral territorial office code.
\item \code{catr_munic}: Municipality code as recorded on the Cadastre.
\item \code{catrcode}: Full Cadastral code for the municipality.
\item \code{cpro}: Province code as per the INE.
\item \code{catr_munic}: Municipality code as per the INE.
\item \code{catrcode}: Full INE code for the municipality.
\item Rest of fields: Check the API Docs.
}
}
\examples{
\dontshow{if (run_example()) withAutoprint(\{ # examplesIf}
\donttest{
# Get municipality by cadastal code
ab <- catr_ovc_get_cod_munic(cpro = 2, cmun = 900)

ab

# Same query using the INE code

ab2 <- catr_ovc_get_cod_munic(cpro = 2, cmun_ine = 3)

ab2
}
\dontshow{\}) # examplesIf}
}
\references{
\href{https://ovc.catastro.meh.es/ovcservweb/ovcswlocalizacionrc/ovccallejerocodigos.asmx?op=ConsultaMunicipioCodigos}{ConsultaMunicipioCodigos}.
}
\seealso{
\code{\link[mapSpain:esp_get_munic_siane]{mapSpain::esp_get_munic_siane()}} to get shapes of municipalities, including
the INE code.

OVCCoordenadas API:
\code{\link{catr_ovc_get_cod_provinces}()}

Other search: 
\code{\link{catr_atom_search_munic}()},
\code{\link{catr_get_code_from_coords}()},
\code{\link{catr_ovc_get_cod_provinces}()}
}
\concept{OVCCallejero}
\concept{search}
