\name{Efficacy_curve}
\alias{Efficacy_curve}

\title{
Efficacy curve for a predictive model/biomarker
}
\description{
The curve plot the efficacy of a predictive model for different missclassfication event rates
}
\usage{Efficacy_curve(Prob,yt)
}

\arguments{
  \item{Prob}{A vector with the event probability values provided by the biomarker
}
\item{yt}{A vector with the actual event values
}
}
\details{
Prob must be a numeric vector with values between 0 and 1, yt  a numeric vector with dichotomic values 0/1 and z a numeric value between 0 and 100
}
\value{
The returned fit object of Efficacy_curve contains the plot of the Efficacy curve.
\item{EfficacyCurve}{Plot of the Efficacy of the biomarker Prob at different rates of missclasified events}
}

\author{Maria Escorihuela, Luis Mariano Esteban, Gerardo Sanz, Angel Borque
}

\examples{
###We generate a marker to serve as an example and plot the curve

Prob<-c(rnorm(1000,0.4,0.1),rnorm(1000,0.5,0.05))
yt<-rep(c(0,1),c(1000,1000))

Efficacy_curve(Prob=Prob,yt=yt)
}

\keyword{misc}
\keyword{clinical utility}
