% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/object.R
\name{summary.BayesPET_oc}
\alias{summary.BayesPET_oc}
\alias{print.summary.BayesPET_oc}
\title{Summary method for BayesPET operating characteristics object}
\usage{
\method{summary}{BayesPET_oc}(object, thresholds = c(0.25, 0.5, 1, 1.5, 2), ...)

\method{print}{summary.BayesPET_oc}(x, digits = 3, ...)
}
\arguments{
\item{object}{An object of class \code{"BayesPET_oc"} returned by \code{\link{get_oc}}.}

\item{thresholds}{Numeric vector of non-negative thresholds used to compute
the proportion of replicates for which the absolute prediction error is
less than each threshold. Defaults to
\code{c(0.25, 0.5, 1, 1.5, 2)}.}

\item{...}{Not used.}

\item{x}{An object of class \code{"summary.BayesPET_oc"} returned by
\code{\link{summary.BayesPET_oc}}.}

\item{digits}{Integer specifying the number of decimal places to use when printing
numerical summaries. Defaults to \code{3}.}
}
\value{
\code{\link{summary.BayesPET_oc}} returns an object of class \code{"summary.BayesPET_oc"}, a list containing:
\itemize{
\item \code{n_valid}: Number of valid simulation replicates (where the target
event count can be reached).
\item \code{n_attempt}: Number of datasets generated to obtain the valid
replicates.
\item \code{success_rate}: Proportion of attempted datasets that produced
valid replicates.
\item \code{thresholds}: Threshold values used to evaluate prediction accuracy.
\item \code{pr_lt}: Proportion of replicates with prediction error less than
each threshold.
\item \code{mae}: Mean absolute prediction error.
\item \code{median_ae}: Median absolute prediction error.
\item \code{rmse}: Root mean squared prediction error.
\item \code{call}: The matched function call.
}

\code{\link{print.summary.BayesPET_oc}} returns the object \code{x}, invisibly.
}
\description{
Computes summary measures of prediction accuracy from a
\code{"BayesPET_oc"} object. The summaries are based on the
differences between the predicted median and true
calendar times to reach the target number of events.
}
\examples{
\dontshow{if (requireNamespace("rstan", quietly = TRUE)) withAutoprint(\{ # examplesIf}
\donttest{
## Using nsim = 2, chains = 2, and iter = 2000 to reduce runtime.
## Use larger nsim, chains and iter in real analyses.
oc <- get_oc(
  N = 200, E_target = 150,
  E_cutoff = 75, p_trt = 0.5,
  cov_type = c("binary", "continuous"),
  cov_dist = c(0.5, 2),
  beta.event = c(-0.2, -0.2),
  beta.censor = c(0, 0),
  logHR.trt = log(0.65),
  enroll_rate = 16,
  dist.event = "Weibull", dist.censor = "Weibull",
  event.scale = 1/5^3, event.shape = 3,
  censor.scale = 1/10^6, censor.shape = 6,
  blinded = TRUE,
  assess_window = 2,
  seed = 1,
  chains = 2, iter = 2000,
  nsim = 2,
  n_workers = 1
)

summary(oc)
}
\dontshow{\}) # examplesIf}
}
\seealso{
Other BayesPET operating characteristics: 
\code{\link{get_oc}()}
}
\concept{BayesPET operating characteristics}
