% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/help.R
\name{arguments.order}
\alias{arguments.order}
\title{Shared documentation for models order}
\arguments{
\item{inf}{a length 1 or 2 integer vector given the truncation point for
infinite sums. Default is \code{inf = 1000}. See the Section \link[=arguments.order]{Model Order} for details.}

\item{p}{optional; a length 1 or 2 integer vector given the order of the AR
polynomial (extract and fit only). Default is \code{p = NULL}. See the Section
\link[=arguments.order]{Model Order} for details.}

\item{q}{optional; a length 1 or 2 integer vector given the order of the MA
polynomial (extract and fit only). Default is \code{q = NULL}. See the Section
\link[=arguments.order]{Model Order} for details.}

\item{d}{a length 1 or 2 logical vector indicating whether the long memory
parameter \eqn{d} should be included in the model either as a fixed or
non-fixed parameter (fit only). If \code{d = FALSE}, internally the value of the
parameter \code{d} is fixed as 0. In this case, if \code{start} or \code{fixed.values}
include \code{d}, the value provided by the user is ignored.  If \eqn{\nu} is
time-varying and a single value is provided it is assumed that \eqn{d_1 =
  d_2 = d}.}
}
\description{
This is the common documentation for arguments related to order of
polynomials and truncation points for infinite sums, presented in BTSR models.
}
\section{Model Order}{
The coefficients \eqn{\{c_{ik}\}_{k\geq 0}} are defined through the relation
(see the section \sQuote{The BTSR Structure} in \link{btsr-package})
\deqn{
c_i(z) := (1-L)^{-d_i}\theta_i(z) = \sum_{k = 0}^\infty c_{ik}z^k, \quad i \in \{1,2\}.
}
where \eqn{\theta_i(z) = \sum_{k = 0}^{q_i} \theta_{ik}z^k} is the moving
average characteristic polynomial, with order \eqn{q_i}. For practical
purposes, the following approximation is used
\deqn{
c_i(z) \approx \sum_{k = 0}^{K_i} c_{ik}z^k,
}
for some \eqn{K_i} sufficiently large. \cr

\code{inf} corresponds to the truncation point for all infinite sums using the
coefficients \eqn{\{c_{ik}\}_{k\geq 0}}, \eqn{i \in \{1,2\}}, including
samples generation and derivatives calculation. It can be provided as either
a single integer (legacy format) or a length 2 integer vector (new format)
specifying the trunction points for \code{part1}/\code{part2}. If \eqn{\nu} is
time-varying and a single value is provided the same value is used for both
parts. When \eqn{d = 0}, Fortran automatically sets \code{inf} to \eqn{q} (MA
order). \cr

By default \code{p} and \code{q} are set to \code{NULL}, in which case their values are
computed internally, based on the size of the argument \code{phi} and \code{theta},
respectively, in the lists of coefficients (or staring values), fixed lags,
and fixed values. For fitting purposes, if \code{p} (analogously, \code{q}) and \code{start}
are both \code{NULL}, an error message is issued. These parameters can be
provided as either a single integer (legacy format) or a length 2 integer
vector (new format) specifying orders for \code{part1}/\code{part2}. If \eqn{\nu} is
time-varying and a single value of \code{p} (analogously, \code{q}) is provided it is
assumed that \eqn{p_1 = p_2 = p} (analogously, \eqn{q_1 = q_2 = q}).
}

