% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tweakPedigree.R
\name{makeTwins}
\alias{makeTwins}
\title{makeTwins}
\usage{
makeTwins(
  ped,
  ID_twin1 = NA_integer_,
  ID_twin2 = NA_integer_,
  gen_twin = 2,
  verbose = FALSE,
  zygosity = "MZ"
)
}
\arguments{
\item{ped}{A \code{data.frame} in the same format as the output of \code{simulatePedigree}.}

\item{ID_twin1}{A vector of \code{ID} of the first twin.}

\item{ID_twin2}{A vector of \code{ID} of the second twin.}

\item{gen_twin}{A vector of \code{generation} of the twin to be imputed.}

\item{verbose}{logical.  If TRUE, print progress through stages of algorithm}

\item{zygosity}{A character string indicating the zygosity of the twins. Default is "MZ" for monozygotic twins.}
}
\value{
Returns a \code{data.frame} with MZ twins information added as a new column.
}
\description{
A function to impute twins in the simulated pedigree \code{data.frame}.
Twins can be imputed by specifying their IDs or by specifying the generation the twin should be imputed.
This is a supplementary function for \code{simulatePedigree}.
}
