% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dztpln.r
\name{dztpln}
\alias{dztpln}
\alias{rztpln}
\title{The zero-truncated compund poisson-lognormal distributions}
\usage{
dztpln(x, mu, sig, log = FALSE, type1 = TRUE)

rztpln(n, mu, sig, type1 = TRUE)
}
\arguments{
\item{x}{vector of (non-negative integer) quantiles.}

\item{mu}{mean of lognormal distribution.}

\item{sig}{standard deviation of lognormal distribution.}

\item{log}{logical; if TRUE, probabilities p are given as log(p).}

\item{type1}{logical; if TRUE, Use type 1 ztpln else use type 2.}

\item{n}{number of random values to return.}
}
\value{
dztpln gives the (log) density and rztpln generates
random variates.
}
\description{
Density function and random generation for Zero-Trauncated Poisson Lognormal
distribution with parameters \code{mu} and sd \code{sig}.
}
\details{
A compound Poisson-lognormal distribution is a Poisson probability
distribution where its parameter \eqn{\lambda} is a random variable with
lognormal distribution, that is to say \eqn{log\lambda} are normally
distributed with mean \eqn{\mu} and variance \eqn{\sigma^2} (Bulmer 1974).
The zero-truncated Poisson-lognormal distribution can be derived from a
zero-truncated Poisson distribution.

Type 1 ZTPLN truncates zero based on Poisson-lognormal distribution and
type 2 ZTPLN truncates zero based on zero-truncated Poisson distribution.
For mathematical details, please see \code{vignette("ztpln")}
}
\examples{
rztpln(n = 10, mu = 0, sig = 1, type1 = TRUE)
rztpln(n = 10, mu = 6, sig = 4, type1 = TRUE)
dztpln(x = 1:5, mu = 1, sig = 2)
}
\references{
Bulmer, M. G. 1974. On Fitting the Poisson Lognormal Distribution to Species-Abundance Data. Biometrics 30:101-110.
}
\seealso{
\code{\link{dztplnm}}
}
