% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/zooaRch.r
\name{mort.func}
\alias{mort.func}
\title{Analysis of Mortality Profiles}
\usage{
mort.func(mortData, labels = NULL, models = NULL, ci = 95, plot = TRUE,
  iter = 1000, usermod = NULL, lsize = 0.1)
}
\arguments{
\item{mortData}{is the age-at-death dataset. This function inputs datasets composed of three columns.
The first column denotes the genus; the second is the age class (this MUST be numeric)
if data contains nominal age classes (e.g., 'A', 'B', 'C', etc.) these data must be converted
to numbers (e.g., A = 1, B = 2, etc.).}

\item{labels}{Character value indicating wether age class labels wishing to be displayed.}

\item{models}{A numerical value (1-5) indiacting the models to compare the data to. Currently mort.func
makes use of 5 mortality models: 1) Security (ref); 2) Milk (ref); 3) Wool (ref);
4) Catastrophic (Stiner 1990); and 5) Attritional (Stiner 1990). More models will be added soon.
An option to include user's own model will also be available.}

\item{ci}{Numerical value indicating desired CI level (e.g., 90, 95, 99). Defaults to 95.}

\item{plot}{A logical value indicating wether user wishes an output plot. Default = TRUE.}

\item{iter}{A numeric value indicating the number of bootstrap iterations. Defaults to 1000.}

\item{usermod}{numeric list (see help(list)) user-specified mortality model. See example 3 below.
Data must be entered as a list, else user will receive error.}

\item{lsize}{A numeric value indicating the vertical spacing value in a legend.}
}
\value{
Function returns a matrix with the following components
  \item{Lower and Upper CI}{typically the 97.5 and 2.5 percentile markers}
  \item{Point Value}{the y value on the mortality profile}
}
\description{
This is a function used to conduct mortality analyses of zooarchaeological data
}
\details{
This function plots mortality profiles, along with Confidence Intervals
using dental eruption and wear data. Optionally, plotted mortality profiles can
be compared to idealized models of mortality.
}
\examples{
# Example 1: Payne 1973
 data(marjRab)

# Inspect data structure
 head(marjRab)

# create age-class labels: Payne 1973 uses ageclasses A-I
 Labels <-c('A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I')
 mort.func(mortData=marjRab,labels=Labels, models=1:3, ci=95, plot=TRUE, iter=1000)

# Example 2: Garnsey Site Bison Data (from Speth 1983)
 data(speth83)

# Inspect data structure
 head(speth83)

# create age-class labels using the 13 age classes of Speth's (1983) scheme.
 Labels <-c(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13)

# Use the catastrophic and attritional mortality curves (after Stiner 1990).
 mort.func(mortData=speth83,labels=Labels, models=4:5, ci=95, plot=TRUE, iter=1000)
}
\author{
Erik Otarola-Castillo.
}
\references{
Klein, R.G., Cruz-Uribe, K., 1983. The Analysis of Animal Bones from Archaeological Sites, University of Chicago Press, Chicago.

Stiner, M. C. 1990  The Use of Mortality Patterns in Archaeological Studies
of Hominid Predatory Adaptations. Journal of Anthropological Archaeology 9:305 - 351.

Lyman, R.L., 1994. Vertebrate Taphonomy, Cambridge University Press, Cambridge.

Voorhies, M. R., 1969  Taphonomy and Population Dynamics of an Early Pliocene Vertebrate Fauna, Knox County, Nebraska. University of Wymonig Press. Contributions to Geology, Special Paper No. 1, Laramie (WY).

Reitz, E. and E. Wing 2008	Zooarchaeology. Second Edition. Cambridge University Press, Cambridge.
}
\keyword{analysis}

