% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zlib.R
\name{compress}
\alias{compress}
\title{Single-step compression of raw data}
\usage{
compress(
  data,
  level = -1,
  method = zlib$DEFLATED,
  wbits = zlib$MAX_WBITS,
  memLevel = zlib$DEF_MEM_LEVEL,
  strategy = zlib$Z_DEFAULT_STRATEGY,
  zdict = NULL
)
}
\arguments{
\item{data}{Raw data to be compressed.}

\item{level}{Compression level, default is -1.}

\item{method}{Compression method, default is \code{zlib$DEFLATED}.}

\item{wbits}{Window bits, default is \code{zlib$MAX_WBITS}.}

\item{memLevel}{Memory level, default is \code{zlib$DEF_MEM_LEVEL}.}

\item{strategy}{Compression strategy, default is \code{zlib$Z_DEFAULT_STRATEGY}.}

\item{zdict}{Optional predefined compression dictionary as a raw vector.}
}
\value{
A raw vector containing the compressed data.
}
\description{
Compresses the provided raw data in a single step.
}
\details{
The \code{compress} function simplifies the compression process by encapsulating
the creation of a compression object, compressing the data, and flushing the buffer
all within a single call. This is particularly useful for scenarios where the user
wants to quickly compress data without dealing with the intricacies of compression
objects and buffer management. The function leverages the \code{compressobj} function
to handle the underlying compression mechanics.
}
\examples{
compressed_data <- compress(charToRaw("some data"))

}
