% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot1dloon.R
\name{boxplot_1d_loon}
\alias{boxplot_1d_loon}
\title{Boxplot in 1d using the interactive loon package}
\usage{
boxplot_1d_loon(zargs, color = NULL, linecolor = NULL, lwd = 2,
  range = NULL, showLabels = FALSE, showScales = FALSE,
  showGuides = FALSE, linkingGroup = NULL, baseplot = NULL, parent,
  ...)
}
\arguments{
\item{zargs}{The argument list as passed from \code{\link{zenplot}()}}

\item{color}{colour for boxplot}

\item{linecolor}{Colour used for the lines to draw the boxplot}

\item{lwd}{The parameter line width for whiskers and median and box
boundaries}

\item{range}{numerical value used to determine how far the plot whiskers
extend. If NULL, the whiskers (range) grows with sample size.}

\item{showLabels}{Logical determining whether axis labels are displayed}

\item{showScales}{Logical determining whether scales are displayed}

\item{showGuides}{Logical determining whether the background guidelines
are displayed}

\item{linkingGroup}{A string specifying the initial group of plots to be
linked to this plot}

\item{baseplot}{If non-null the base plot on which the plot should be layered}

\item{parent}{The tk parent for this loon plot widget}

\item{...}{Additional parameters passed to gpar()}
}
\value{
A loon loon::l_plot(...)
}
\description{
Boxplot in 1d using the interactive loon package
}
\seealso{
Other default 1d plot functions using the interactive loon package: \code{\link{arrow_1d_loon}},
  \code{\link{density_1d_loon}},
  \code{\link{hist_1d_loon}}, \code{\link{jitter_1d_loon}},
  \code{\link{label_1d_loon}}, \code{\link{lines_1d_loon}},
  \code{\link{points_1d_loon}}, \code{\link{rect_1d_loon}},
  \code{\link{rug_1d_loon}}

Other default 1d plot functions: \code{\link{arrow_1d_graphics}},
  \code{\link{arrow_1d_grid}}, \code{\link{arrow_1d_loon}},
  \code{\link{boxplot_1d_graphics}},
  \code{\link{boxplot_1d_grid}},
  \code{\link{density_1d_graphics}},
  \code{\link{density_1d_grid}},
  \code{\link{density_1d_loon}}, \code{\link{extract_1d}},
  \code{\link{hist_1d_graphics}},
  \code{\link{hist_1d_grid}}, \code{\link{hist_1d_loon}},
  \code{\link{jitter_1d_graphics}},
  \code{\link{jitter_1d_grid}},
  \code{\link{jitter_1d_loon}},
  \code{\link{label_1d_graphics}},
  \code{\link{label_1d_grid}}, \code{\link{label_1d_loon}},
  \code{\link{lines_1d_graphics}},
  \code{\link{lines_1d_grid}}, \code{\link{lines_1d_loon}},
  \code{\link{points_1d_graphics}},
  \code{\link{points_1d_grid}},
  \code{\link{points_1d_loon}},
  \code{\link{rect_1d_graphics}},
  \code{\link{rect_1d_grid}}, \code{\link{rect_1d_loon}},
  \code{\link{rug_1d_graphics}}, \code{\link{rug_1d_grid}},
  \code{\link{rug_1d_loon}}
}
\author{
Marius Hofert and Wayne Oldford
}
\concept{default 1d plot functions}
\concept{default 1d plot functions using the interactive loon package}
