% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shell.R
\name{z.Shell}
\alias{z.Shell}
\title{Shell correlation from Kumar thesis (2005)}
\usage{
z.Shell(pres.pr, temp.pr, tolerance = 1e-13, verbose = FALSE)
}
\arguments{
\item{pres.pr}{pseudo-reduced pressure}

\item{temp.pr}{pseudo-reduced temperature}

\item{tolerance}{controls the iteration accuracy}

\item{verbose}{print internal}
}
\description{
Shell correlation from Kumar thesis (2005)
}
\examples{
# single z point and create a dataframe with info
ppr <- 1.5
tpr <- 1.1
z.calc <- z.Shell(pres.pr = ppr, temp.pr = tpr)
# From the Standing-Katz chart we obtain a digitized point:
z.chart <- getStandingKatzMatrix(tpr_vector = tpr,
                                 pprRange = "lp")[1, as.character(ppr)]
ape <- abs((z.calc - z.chart) / z.chart) * 100
df <- as.data.frame(list(Ppr = ppr,  z.calc =z.calc, z.chart = z.chart, ape=ape))
rownames(df) <- tpr
df
}
