context("yield")

test_that("yield", {
  expect_equal(ypr_yield(ypr_population()), 0.03493376, tolerance = 1e-06, check.attributes = FALSE)
  expect_equal(ypr_yield(ypr_population(), harvest = FALSE), 0.03493376, tolerance = 1e-06, check.attributes = FALSE)
  expect_equal(ypr_yield(ypr_population(rho = 0.4)), ypr_yield(ypr_population(pi = 0.2 * 0.6)), tolerance = 1e-06, check.attributes = FALSE)
  expect_equal(ypr_yield(ypr_population(rho = 0.4), harvest = FALSE), 0.1215271, tolerance = 1e-06, check.attributes = FALSE)
  expect_equal(ypr_yield(ypr_population(rho = 0.4, Hm = 0.3)), 0.05576617, tolerance = 1e-06, check.attributes = FALSE)
  expect_equal(ypr_yield(ypr_population(rho = 0.4, Hm = 0.3), harvest = FALSE), 0.09294362, tolerance = 1e-06, check.attributes = FALSE)
  expect_equal(ypr_yield(ypr_population(Rmax = 1000)), 34.93376, tolerance = 1e-03, check.attributes = FALSE)
  expect_equal(ypr_yield(ypr_population(BH = 0L)), 0.08827256, tolerance = 1e-03, check.attributes = FALSE)
  expect_equal(ypr_yield(ypr_population(Rmax = 1000, BH = 0L)), 88.27256, tolerance = 1e-03, check.attributes = FALSE)
  expect_equal(ypr_yield(ypr_population(), biomass = TRUE), 0.09256122, tolerance = 1e-06, check.attributes = FALSE)
  expect_equal(ypr_yield(ypr_population(), biomass = TRUE, Ly = 70), 0.0325123, tolerance = 1e-06, check.attributes = FALSE)
})
