% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getBowlerWicketDetails.R
\name{getBowlerWicketDetails}
\alias{getBowlerWicketDetails}
\title{Get the bowling details of a bowler}
\usage{
getBowlerWicketDetails(team,name,dir=".")
}
\arguments{
\item{team}{The team to which the bowler belongs}

\item{name}{The name of the bowler}

\item{dir}{The source directory of the data}
}
\value{
dataframe
The dataframe of bowling performance
}
\description{
This function gets the bowling of a bowler (overs,maidens,runs,wickets,venue, opposition)
}
\note{
Maintainer: Tinniam V Ganesh \email{tvganesh.85@gmail.com}
}
\examples{
\dontrun{
# Get the bowling details of bowlers of a team e.g. India. This is saved as a dataframe
c <- getTeamBowlingDetails("India",dir="../data",save=TRUE)
#Get the bowler details from this overall data frame

jadeja <- getBowlerWicketDetails(team="India",name="Jadeja",dir=".")

# The dataframe from the above call is used in many functions
#bowlerMeanEconomyRate(jadeja,"RA Jadeja")
}

}
\references{
\url{https://cricsheet.org/}\cr
\url{https://gigadom.in/}\cr
\url{https://github.com/tvganesh/yorkrData/}
}
\seealso{
\code{\link{bowlerMovingAverage}}\cr
\code{\link{getTeamBowlingDetails}}\cr
\code{\link{bowlerMeanRunsConceded}}\cr
\code{\link{teamBowlersWicketRunsOppnAllMatches}}\cr
}
\author{
Tinniam V Ganesh
}
