% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkbox.R
\name{checkbarInput}
\alias{checkbarInput}
\alias{updateCheckbarInput}
\title{Checkbar input}
\usage{
checkbarInput(id, choices = NULL, values = choices, selected = NULL, ...)

updateCheckbarInput(
  id,
  choices = NULL,
  values = choices,
  selected = NULL,
  enable = NULL,
  disable = NULL,
  session = getDefaultReactiveDomain()
)
}
\arguments{
\item{id}{A character string specifying the id of the reactive input.}

\item{choices}{A character vector or list of tag element specifying the
input's choices, defaults to \code{NULL}.}

\item{values}{A vector of values specifying the values of the input's
choices, defaults to \code{choices}.}

\item{selected}{One or more of \code{values} specifying the input's default
selected values, defaults to \code{NULL}.}

\item{...}{Additional named arguments passed as HTML attributes to the
parent element or tag elements passed as child elements to the parent
element.}

\item{enable}{One of \code{values} specifying particular choices to enable or
\code{TRUE} specifying the entire input is enabled, defaults to \code{NULL}.}

\item{disable}{One of \code{values} specifying particular choices to disable or
\code{TRUE} specifying the entire input is disabled, defaults to \code{NULL}.}

\item{session}{A reactive context, defaults to \code{\link[=getDefaultReactiveDomain]{getDefaultReactiveDomain()}}.}
}
\description{
A stylized checkbox input. The checkbar input appears similar to a group of
buttons, but with a checked or highlighted state.
}
\examples{

### Default checkbar

checkbarInput(
  id = "cb1",
  choices = c("When", "Why", "Where")
)

### Modifying background color

checkbarInput(
  id = "cb2",
  choices = c("What", "Which")
) \%>\%
  background("teal")

### Labeling a checkbar

formGroup(
  label = "Toppings",
  checkbarInput(
    id = "fixins",
    choices = c(
      "Sprinkles",
      "Nuts",
      "Fudge"
    )
  )
)

}
\seealso{
Other inputs: 
\code{\link{buttonGroupInput}()},
\code{\link{buttonInput}()},
\code{\link{checkboxInput}()},
\code{\link{chipInput}()},
\code{\link{fileInput}()},
\code{\link{formInput}()},
\code{\link{listGroupInput}()},
\code{\link{menuInput}()},
\code{\link{navInput}()},
\code{\link{radioInput}()},
\code{\link{radiobarInput}()},
\code{\link{rangeInput}()},
\code{\link{selectInput}()},
\code{\link{textInput}()}
}
\concept{inputs}
