% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert.R
\name{assertions}
\alias{assertions}
\alias{assert_integer}
\alias{assert_int}
\alias{assert_integer_not_na}
\alias{assert_int_not_na}
\alias{assert_double}
\alias{assert_dbl}
\alias{assert_double_not_na}
\alias{assert_dbl_not_na}
\alias{assert_numeric}
\alias{assert_num}
\alias{assert_numeric_not_na}
\alias{assert_num_not_na}
\alias{assert_logical}
\alias{assert_lgl}
\alias{assert_logical_not_na}
\alias{assert_lgl_not_na}
\alias{assert_character}
\alias{assert_chr}
\alias{assert_character_not_na}
\alias{assert_chr_not_na}
\alias{assert_data_frame}
\alias{assert_list}
\alias{assert_whole}
\alias{assert_integerish}
\alias{assert_scalar_integer}
\alias{assert_scalar_int}
\alias{assert_scalar_integer_not_na}
\alias{assert_scalar_int_not_na}
\alias{assert_scalar_double}
\alias{assert_scalar_dbl}
\alias{assert_scalar_double_not_na}
\alias{assert_scalar_dbl_not_na}
\alias{assert_scalar_numeric}
\alias{assert_scalar_num}
\alias{assert_scalar_numeric_not_na}
\alias{assert_scalar_num_not_na}
\alias{assert_scalar_logical}
\alias{assert_scalar_lgl}
\alias{assert_scalar_logical_not_na}
\alias{assert_scalar_lgl_not_na}
\alias{assert_scalar_whole}
\alias{assert_scalar_integerish}
\alias{assert_bool}
\alias{assert_boolean}
\alias{assert_scalar_character}
\alias{assert_scalar_chr}
\alias{assert_string}
\alias{assert_scalar_character_not_na}
\alias{assert_scalar_chr_not_na}
\alias{assert_string_not_na}
\alias{assert_non_negative_or_na}
\alias{assert_non_positive_or_na}
\alias{assert_non_negative}
\alias{assert_non_positive}
\alias{assert_positive}
\alias{assert_negative}
\alias{assert_positive_or_na}
\alias{assert_negative_or_na}
\alias{assert_between}
\title{Argument assertions (Experimental)}
\usage{
assert_integer(
  x,
  .arg = deparse(substitute(x)),
  .call = sys.call(-1L),
  .subclass = NULL
)

assert_int(
  x,
  .arg = deparse(substitute(x)),
  .call = sys.call(-1L),
  .subclass = NULL
)

assert_integer_not_na(
  x,
  .arg = deparse(substitute(x)),
  .call = sys.call(-1L),
  .subclass = NULL
)

assert_int_not_na(
  x,
  .arg = deparse(substitute(x)),
  .call = sys.call(-1L),
  .subclass = NULL
)

assert_double(
  x,
  .arg = deparse(substitute(x)),
  .call = sys.call(-1L),
  .subclass = NULL
)

assert_dbl(
  x,
  .arg = deparse(substitute(x)),
  .call = sys.call(-1L),
  .subclass = NULL
)

assert_double_not_na(
  x,
  .arg = deparse(substitute(x)),
  .call = sys.call(-1L),
  .subclass = NULL
)

assert_dbl_not_na(
  x,
  .arg = deparse(substitute(x)),
  .call = sys.call(-1L),
  .subclass = NULL
)

assert_numeric(
  x,
  .arg = deparse(substitute(x)),
  .call = sys.call(-1L),
  .subclass = NULL
)

assert_num(
  x,
  .arg = deparse(substitute(x)),
  .call = sys.call(-1L),
  .subclass = NULL
)

assert_dbl_not_na(
  x,
  .arg = deparse(substitute(x)),
  .call = sys.call(-1L),
  .subclass = NULL
)

assert_numeric_not_na(
  x,
  .arg = deparse(substitute(x)),
  .call = sys.call(-1L),
  .subclass = NULL
)

assert_num_not_na(
  x,
  .arg = deparse(substitute(x)),
  .call = sys.call(-1L),
  .subclass = NULL
)

assert_logical(
  x,
  .arg = deparse(substitute(x)),
  .call = sys.call(-1L),
  .subclass = NULL
)

assert_lgl(
  x,
  .arg = deparse(substitute(x)),
  .call = sys.call(-1L),
  .subclass = NULL
)

assert_logical_not_na(
  x,
  .arg = deparse(substitute(x)),
  .call = sys.call(-1L),
  .subclass = NULL
)

assert_lgl_not_na(
  x,
  .arg = deparse(substitute(x)),
  .call = sys.call(-1L),
  .subclass = NULL
)

assert_character(
  x,
  .arg = deparse(substitute(x)),
  .call = sys.call(-1L),
  .subclass = NULL
)

assert_chr(
  x,
  .arg = deparse(substitute(x)),
  .call = sys.call(-1L),
  .subclass = NULL
)

assert_character_not_na(
  x,
  .arg = deparse(substitute(x)),
  .call = sys.call(-1L),
  .subclass = NULL
)

assert_chr_not_na(
  x,
  .arg = deparse(substitute(x)),
  .call = sys.call(-1L),
  .subclass = NULL
)

assert_data_frame(
  x,
  .arg = deparse(substitute(x)),
  .call = sys.call(-1L),
  .subclass = NULL
)

assert_list(
  x,
  .arg = deparse(substitute(x)),
  .call = sys.call(-1L),
  .subclass = NULL
)

assert_whole(
  x,
  .arg = deparse(substitute(x)),
  .call = sys.call(-1L),
  .subclass = NULL
)

assert_integerish(
  x,
  .arg = deparse(substitute(x)),
  .call = sys.call(-1L),
  .subclass = NULL
)

assert_scalar_integer(
  x,
  .arg = deparse(substitute(x)),
  .call = sys.call(-1L),
  .subclass = NULL
)

assert_scalar_int(
  x,
  .arg = deparse(substitute(x)),
  .call = sys.call(-1L),
  .subclass = NULL
)

assert_scalar_integer_not_na(
  x,
  .arg = deparse(substitute(x)),
  .call = sys.call(-1L),
  .subclass = NULL
)

assert_scalar_int_not_na(
  x,
  .arg = deparse(substitute(x)),
  .call = sys.call(-1L),
  .subclass = NULL
)

assert_scalar_double(
  x,
  .arg = deparse(substitute(x)),
  .call = sys.call(-1L),
  .subclass = NULL
)

assert_scalar_dbl(
  x,
  .arg = deparse(substitute(x)),
  .call = sys.call(-1L),
  .subclass = NULL
)

assert_scalar_double_not_na(
  x,
  .arg = deparse(substitute(x)),
  .call = sys.call(-1L),
  .subclass = NULL
)

assert_scalar_dbl_not_na(
  x,
  .arg = deparse(substitute(x)),
  .call = sys.call(-1L),
  .subclass = NULL
)

assert_scalar_numeric(
  x,
  .arg = deparse(substitute(x)),
  .call = sys.call(-1L),
  .subclass = NULL
)

assert_scalar_num(
  x,
  .arg = deparse(substitute(x)),
  .call = sys.call(-1L),
  .subclass = NULL
)

assert_scalar_numeric_not_na(
  x,
  .arg = deparse(substitute(x)),
  .call = sys.call(-1L),
  .subclass = NULL
)

assert_scalar_num_not_na(
  x,
  .arg = deparse(substitute(x)),
  .call = sys.call(-1L),
  .subclass = NULL
)

assert_scalar_logical(
  x,
  .arg = deparse(substitute(x)),
  .call = sys.call(-1L),
  .subclass = NULL
)

assert_scalar_lgl(
  x,
  .arg = deparse(substitute(x)),
  .call = sys.call(-1L),
  .subclass = NULL
)

assert_scalar_logical_not_na(
  x,
  .arg = deparse(substitute(x)),
  .call = sys.call(-1L),
  .subclass = NULL
)

assert_scalar_lgl_not_na(
  x,
  .arg = deparse(substitute(x)),
  .call = sys.call(-1L),
  .subclass = NULL
)

assert_scalar_whole(
  x,
  .arg = deparse(substitute(x)),
  .call = sys.call(-1L),
  .subclass = NULL
)

assert_scalar_integerish(
  x,
  .arg = deparse(substitute(x)),
  .call = sys.call(-1L),
  .subclass = NULL
)

assert_bool(
  x,
  .arg = deparse(substitute(x)),
  .call = sys.call(-1L),
  .subclass = NULL
)

assert_boolean(
  x,
  .arg = deparse(substitute(x)),
  .call = sys.call(-1L),
  .subclass = NULL
)

assert_scalar_character(
  x,
  .arg = deparse(substitute(x)),
  .call = sys.call(-1L),
  .subclass = NULL
)

assert_scalar_chr(
  x,
  .arg = deparse(substitute(x)),
  .call = sys.call(-1L),
  .subclass = NULL
)

assert_string(
  x,
  .arg = deparse(substitute(x)),
  .call = sys.call(-1L),
  .subclass = NULL
)

assert_scalar_character_not_na(
  x,
  .arg = deparse(substitute(x)),
  .call = sys.call(-1L),
  .subclass = NULL
)

assert_scalar_chr_not_na(
  x,
  .arg = deparse(substitute(x)),
  .call = sys.call(-1L),
  .subclass = NULL
)

assert_string_not_na(
  x,
  .arg = deparse(substitute(x)),
  .call = sys.call(-1L),
  .subclass = NULL
)

assert_non_negative_or_na(
  x,
  .arg = deparse(substitute(x)),
  .call = sys.call(-1L),
  .subclass = NULL
)

assert_non_positive_or_na(
  x,
  .arg = deparse(substitute(x)),
  .call = sys.call(-1L),
  .subclass = NULL
)

assert_non_negative(
  x,
  .arg = deparse(substitute(x)),
  .call = sys.call(-1L),
  .subclass = NULL
)

assert_non_positive(
  x,
  .arg = deparse(substitute(x)),
  .call = sys.call(-1L),
  .subclass = NULL
)

assert_positive(
  x,
  .arg = deparse(substitute(x)),
  .call = sys.call(-1L),
  .subclass = NULL
)

assert_negative(
  x,
  .arg = deparse(substitute(x)),
  .call = sys.call(-1L),
  .subclass = NULL
)

assert_positive_or_na(
  x,
  .arg = deparse(substitute(x)),
  .call = sys.call(-1L),
  .subclass = NULL
)

assert_negative_or_na(
  x,
  .arg = deparse(substitute(x)),
  .call = sys.call(-1L),
  .subclass = NULL
)

assert_between(
  x,
  lower = -Inf,
  upper = Inf,
  left_inclusive = TRUE,
  right_inclusive = TRUE,
  .arg = deparse(substitute(x)),
  .call = sys.call(-1L),
  .subclass = NULL
)
}
\arguments{
\item{x}{Argument to check.}

\item{.arg}{\verb{[character]}

Name of argument being checked (used in error message).}

\item{.call}{\verb{[call]}

Call to use in error message.}

\item{.subclass}{\verb{[character]}

The (optional) subclass of the returned error condition.}

\item{lower}{\verb{[numeric]}

The lower bound to compare against.}

\item{upper}{\verb{[numeric]}

The upper bound to compare against.}

\item{left_inclusive}{\verb{[bool]}

Should the left (lower) bound be compared inclusively (\code{<=}) or exclusive (\code{<}).}

\item{right_inclusive}{\verb{[bool]}

Should the right (upper) bound be compared inclusively (\code{>=}) or exclusive (\code{>}).}
}
\value{
If the assertion succeeds then the input is returned invisibly.

Otherwise an error of class "ympes-error" (with optional subclass if supplied
when calling the assertion).
}
\description{
Assertions for function arguments. Motivated by \code{\link[vctrs:vec_assert]{vctrs::vec_assert()}} but
with lower overhead at a cost of less informative error messages. Designed to
make it easy to identify the top level calling function whether used within a
user facing function or internally. They are somewhat experimental in nature
and should be treated accordingly.
}
\examples{

# Use in a user facing function
fun <- function(i, d, l, chr, b) {
    assert_scalar_int(i)
    TRUE
}
fun(i=1L)
try(fun(i="cat"))

# Use in an internal function
internal_fun <- function(a) {
    assert_string(
        a,
        .arg = deparse(substitute(x)),
        .call = sys.call(-1L),
        .subclass = "example_error"
    )
    TRUE
}
external_fun <- function(b) {
    internal_fun(a=b)
}
external_fun(b="cat")
try(external_fun(b = letters))
tryCatch(external_fun(b = letters), error = class)

}
