% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fair-equalized_odds.R
\name{equalized_odds}
\alias{equalized_odds}
\title{Equalized odds}
\usage{
equalized_odds(by)
}
\arguments{
\item{by}{The column identifier for the sensitive feature. This should be an
unquoted column name referring to a column in the un-preprocessed data.}
}
\value{
This function outputs a yardstick \emph{fairness metric} function. Given a
grouping variable \code{by}, \code{equalized_odds()} will return a yardstick metric
function that is associated with the data-variable grouping \code{by} and a
post-processor. The outputted function will first generate a set
of \code{\link[=sens]{sens()}} and \code{\link[=spec]{spec()}} metric values by group before summarizing across
groups using the post-processing function.

The outputted function only has a data frame method and is intended to
be used as part of a metric set.
}
\description{
Equalized odds is satisfied when a model's predictions have the same false
positive, true positive, false negative, and true negative rates across
protected groups. A value of 0 indicates parity across groups.

By default, this function takes the maximum difference in range of \code{\link[=sens]{sens()}}
and \code{\link[=spec]{spec()}} \code{.estimate}s across groups. That is, the maximum pair-wise
disparity in \code{\link[=sens]{sens()}} or \code{\link[=spec]{spec()}} between groups is the return value of
\code{equalized_odds()}'s \code{.estimate}.

Equalized odds is sometimes referred to as conditional procedure accuracy
equality or disparate mistreatment.

See the "Measuring disparity" section for details on implementation.
}
\section{Measuring Disparity}{

For finer control of group treatment, construct a context-aware fairness
metric with the \code{\link[=new_groupwise_metric]{new_groupwise_metric()}} function by passing a custom \code{aggregate}
function:

\if{html}{\out{<div class="sourceCode">}}\preformatted{# see yardstick:::max_positive_rate_diff for the actual `aggregate()`
diff_range <- function(x, ...) \{diff(range(x$.estimate))\}

equalized_odds_2 <-
  new_groupwise_metric(
    fn = metric_set(sens, spec),
    name = "equalized_odds_2",
    aggregate = diff_range
  )
}\if{html}{\out{</div>}}

In \code{aggregate()}, \code{x} is the \code{\link[=metric_set]{metric_set()}} output with \code{\link[=sens]{sens()}} and \code{\link[=spec]{spec()}}
values for each group, and \code{...} gives additional arguments (such as a grouping
level to refer to as the "baseline") to pass to the function outputted
by \code{equalized_odds_2()} for context.
}

\examples{
library(dplyr)

data(hpc_cv)

head(hpc_cv)

# evaluate `equalized_odds()` by Resample
m_set <- metric_set(equalized_odds(Resample))

# use output like any other metric set
hpc_cv \%>\%
  m_set(truth = obs, estimate = pred)

# can mix fairness metrics and regular metrics
m_set_2 <- metric_set(sens, equalized_odds(Resample))

hpc_cv \%>\%
  m_set_2(truth = obs, estimate = pred)
}
\references{
Agarwal, A., Beygelzimer, A., Dudik, M., Langford, J., & Wallach, H. (2018).
"A Reductions Approach to Fair Classification." Proceedings of the 35th
International Conference on Machine Learning, in Proceedings of Machine
Learning Research. 80:60-69.

Verma, S., & Rubin, J. (2018). "Fairness definitions explained". In
Proceedings of the international workshop on software fairness (pp. 1-7).

Bird, S., Dudík, M., Edgar, R., Horn, B., Lutz, R., Milan, V., ... & Walker,
K. (2020). "Fairlearn: A toolkit for assessing and improving fairness in AI".
Microsoft, Tech. Rep. MSR-TR-2020-32.
}
\seealso{
Other fairness metrics: 
\code{\link{demographic_parity}()},
\code{\link{equal_opportunity}()}
}
\concept{fairness metrics}
