% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-kap.R
\name{kap}
\alias{kap}
\alias{kap.data.frame}
\alias{kap_vec}
\title{Kappa}
\usage{
kap(data, ...)

\method{kap}{data.frame}(data, truth, estimate, weighting = "none", na_rm = TRUE, ...)

kap_vec(truth, estimate, weighting = "none", na_rm = TRUE, ...)
}
\arguments{
\item{data}{Either a \code{data.frame} containing the \code{truth} and \code{estimate}
columns, or a \code{table}/\code{matrix} where the true class results should be
in the columns of the table.}

\item{...}{Not currently used.}

\item{truth}{The column identifier for the true class results
(that is a \code{factor}). This should be an unquoted column name although
this argument is passed by expression and supports
\link[rlang:nse-force]{quasiquotation} (you can unquote column
names). For \verb{_vec()} functions, a \code{factor} vector.}

\item{estimate}{The column identifier for the predicted class
results (that is also \code{factor}). As with \code{truth} this can be
specified different ways but the primary method is to use an
unquoted variable name. For \verb{_vec()} functions, a \code{factor} vector.}

\item{weighting}{A weighting to apply when computing the scores. One of:
\code{"none"}, \code{"linear"}, or \code{"quadratic"}. Linear and quadratic weighting
penalizes mis-predictions that are "far away" from the true value. Note
that distance is judged based on the ordering of the levels in \code{truth} and
\code{estimate}. It is recommended to provide ordered factors for \code{truth} and
\code{estimate} to explicitly code the ordering, but this is not required.

In the binary case, all 3 weightings produce the same value, since it is
only ever possible to be 1 unit away from the true value.}

\item{na_rm}{A \code{logical} value indicating whether \code{NA}
values should be stripped before the computation proceeds.}
}
\value{
A \code{tibble} with columns \code{.metric}, \code{.estimator},
and \code{.estimate} and 1 row of values.

For grouped data frames, the number of rows returned will be the same as
the number of groups.

For \code{kap_vec()}, a single \code{numeric} value (or \code{NA}).
}
\description{
Kappa is a similar measure to \code{\link[=accuracy]{accuracy()}}, but is normalized by
the accuracy that would be expected by chance alone and is very useful
when one or more classes have large frequency distributions.
}
\section{Multiclass}{


Kappa extends naturally to multiclass scenarios. Because
of this, macro and micro averaging are not implemented.
}

\examples{
library(dplyr)
data("two_class_example")
data("hpc_cv")

# Two class
kap(two_class_example, truth, predicted)

# Multiclass
# kap() has a natural multiclass extension
hpc_cv \%>\%
  filter(Resample == "Fold01") \%>\%
  kap(obs, pred)

# Groups are respected
hpc_cv \%>\%
  group_by(Resample) \%>\%
  kap(obs, pred)
}
\references{
Cohen, J. (1960). "A coefficient of agreement for nominal
scales". \emph{Educational and Psychological Measurement}. 20 (1): 37-46.

Cohen, J. (1968). "Weighted kappa: Nominal scale agreement provision for
scaled disagreement or partial credit". \emph{Psychological
Bulletin}. 70 (4): 213-220.
}
\seealso{
Other class metrics: 
\code{\link{accuracy}()},
\code{\link{bal_accuracy}()},
\code{\link{detection_prevalence}()},
\code{\link{f_meas}()},
\code{\link{j_index}()},
\code{\link{mcc}()},
\code{\link{npv}()},
\code{\link{ppv}()},
\code{\link{precision}()},
\code{\link{recall}()},
\code{\link{sens}()},
\code{\link{spec}()}
}
\author{
Max Kuhn

Jon Harmon
}
\concept{class metrics}
