% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render_rmd.R
\name{render_rmd}
\alias{render_rmd}
\alias{render_rmd.character}
\alias{render_rmd.rmd_doc}
\title{Render documents from object}
\usage{
render_rmd(input, ...)

\method{render_rmd}{character}(input, ...)

\method{render_rmd}{rmd_doc}(
  input,
  output_file,
  temp_file = "_temp.Rmd",
  delete_temp = TRUE,
  ...
)
}
\arguments{
\item{input}{Either a character value indicating the path and the name of the
r-markdown file, or an object of class \code{rmd_doc}, written by
\code{\link[=write_rmd]{write_rmd()}}.}

\item{...}{Further parameters passed to \code{\link[rmarkdown:render]{rmarkdown::render()}}.}

\item{output_file}{A character value indicating the name of the output file.
It is passed to \code{\link[rmarkdown:render]{rmarkdown::render()}}.}

\item{temp_file}{A name for a temporary file created to render the object.}

\item{delete_temp}{A logical value indicating whether \code{temp_file} should be
deleted after rendering or not.}
}
\description{
This function is a wrapper of \code{\link[rmarkdown:render]{rmarkdown::render()}} and will also work with
file names but also enables the possibility of rendering from objects created
by \code{\link[=write_rmd]{write_rmd()}}.
}
\examples{
\dontrun{
## copy example to your working directory
filename <- "taxlistjourney.Rmd"
file.copy(from=file.path(path.package("yamlme"), filename), to=filename)

## Render the file with rmarkdown::render()
render_rmd(filename, output_file="example")

## Render the file with yamlme
text_document <- read_rmd(filename)

rmd_document <- write_rmd(title="my title", author="my name",
    output="html_document", body=text_document)

render_rmd(rmd_document, output_file="example2")
}

}
