% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module4_cat.R
\name{cat.sim}
\alias{cat.estimate.default}
\alias{cat.select.ccat}
\alias{cat.select.default}
\alias{cat.select.randomesque}
\alias{cat.select.shadow}
\alias{cat.sim}
\alias{cat.stop.default}
\alias{cat.stop.projection}
\alias{plot.cat}
\alias{print.cat}
\title{Computerized Adaptive Testing (CAT) Simulation}
\usage{
cat.sim(theta.true, pool, opts, cat.select = cat.select.default,
  cat.estimate = cat.estimate.default, cat.stop = cat.stop.default,
  debug = FALSE)

\method{print}{cat}(x, ...)

\method{plot}{cat}(x, ...)

cat.select.randomesque(theta, pool, randomesque)

cat.select.default(cat.data)

cat.select.ccat(cat.data)

cat.select.shadow(cat.data)

cat.estimate.default(cat.data)

cat.stop.default(cat.data)

cat.stop.projection(cat.data)
}
\arguments{
\item{theta.true}{the true theta parameter}

\item{pool}{a data frame of items used as the item pool}

\item{opts}{a list of option parameters (\code{min} and \code{max} are required)}

\item{cat.select}{a function of the item selection rule}

\item{cat.estimate}{a function of the ability estimation rule}

\item{cat.stop}{the a function of the stopping rule}

\item{debug}{\code{TRUE} for turning on the debug mode}

\item{x}{a \code{cat} object}

\item{...}{further arguments}

\item{theta}{the current theta estimate}

\item{randomesque}{the randomesque parameter}

\item{cat.data}{a list of CAT data}
}
\value{
\code{cat.sim} returns a \code{cat} object (see details section)

\code{cat.estimate.default} estimates the ability using EAP (all correct/incorrect responses) or MLE (mixed responses)

\code{cat.stop.default} evalutes whether to stop the CAT using the SE rule, MI rule, or CI rule
}
\description{
\code{cat.sim} simulates CAT sessions with user-defined algorithms

\code{cat.select.randomesque} is a helper function for selecting an item from k most informative ones

\code{cat.select.default} selects the most informative item

\code{cat.select.ccat} selects items under content-balancing constraint (see Kingsbury & Zara, 1989, 1991)

\code{cat.select.shadow} implements the shadow test algorithm described in van der Linden (2010)

\code{cat.stop.projection} is the projection-based stopping rule
}
\details{
All data (input and output) are combined into a list named \code{cat.data}, including
the options (\code{opts}), the true theta (\code{true}), the estiamted theta (\code{est}), 
the item pool (\code{pool}), the administered items (\code{items}), the statistics (\code{stats}),
the administration history (\code{admin}), the test length (\code{len}), the debuggin switch (\code{debug}).\cr
To write a new \code{cat.select} function, make sure it only takes \code{cat.data} as input and 
outputs a list with the selected \code{item}, updated \code{pool}, and \code{output} for additional output. 
Retrieve the additional output using \code{output.select} from the returnig \code{cat} object. \cr
To write a new \code{cat.estimate} function, make sure it only takes \code{cat.data} as input and 
outputs a list with the estimated \code{theta}, and \code{output} for additional output. 
Retrieve the additional output using \code{output.estimate} from the returnig \code{cat} object. \cr
To write a new \code{cat.stop} function, make sure it only takes \code{cat.data} as input and 
outputs a list with the boolean \code{stop} decision, and \code{output} for additional output. 
Retrieve the additional output using \code{output.stop} from the returnig \code{cat} object. \cr

\code{cat.select.default} selects the most informative item for current theta.
When \code{randomesque} is set, it randomly select an item from the k most informative ones.

To use \code{cat.select.ccat}, set target (percentage)  using \code{ccat.target} and initial randomness using \code{ccat.random} in options.

\code{cat.select.shadow}: pass all constraints as a data frame with columns as such \code{variable, level, min, max}
to \code{shadow.constraints} in \code{options}.

\code{cat.estimate.default} estimates theta using EAP for a response vector of all 1's or 0's and MLE otherwise

The \code{cat.stop.default} evaluates one of the three criteria after reaching minimum lenght:
(1) if \code{opts$stop.se} is set, evalute if the se reaches the threshold;
(2) if \code{opts$stop.mi} is set, evalute if all item reach the threshold;
(3) if \code{opts$stop.cut} is set, evalute if the 95% confidence interval contains the cut score
}
\examples{
\dontrun{
# generate an item pool
pool <- irt.model()$gen.data(1,200)$items
pool$content <- sample(1:3, nrow(pool), replace=TRUE)
pool$time <- round(exp(rnorm(nrow(pool), log(60), .2)))
# cat simulation: 10-30 items, default rules, stop criterion: se = .3
opts <- list(min=10, max=30, stop.se=.3)
x <- cat.sim(0.1, pool, opts)
x$admin
plot(x)
# cat simulation: 10-30 items, default rules, stop criterion: mi = .3
opts <- list(min=10, max=30, stop.mi=.8)
x <- cat.sim(0.1, pool, opts, debug=TRUE)
# cat simulation: 10-30 items, default rules, stop criterion: cut = -.5
opts <- list(min=10, max=30, stop.cut=-0.5)
x <- cat.sim(0.1, pool, opts, debug=TRUE)
# cat simulation: 10-30 items, default rules, stop criterion: se = .3, randomesque=10
opts <- list(min=10, max=30, stop.se=.3, randomesque=5)
x <- cat.sim(0.1, pool, opts)
x
plot(x)
# cat simulation: 10-30 items, c-cat selection rule, first 10 random
opts <- list(min=30, max=60, stop.cut=0, ccat.target=c(.5,.25,.25), ccat.random=10)
x <- cat.sim(0.1, pool, opts, cat.select=cat.select.ccat)
x
freq(x$admin$content, 1:3)
plot(x)
# cat simulation with shadow test
cons <- data.frame(name="content", level=1, min=10, max=10, stringsAsFactors=FALSE)
cons <- rbind(cons, c("content", 2, 10, 10))
cons <- rbind(cons, c("content", 3, 10, 10))
cons <- rbind(cons, c("time", NA, 55*30, 65*30))
opts <- list(min=30, max=30, stop.se=.03, shadow.constraints=cons)
x <- cat.sim(0.1, pool, opts, cat.select=cat.select.shadow, debug=TRUE)
x
freq(x$admin$content, 1:3)
sum(x$items$time)
plot(x)
# cat simulation using the projection-based stopping rule
cons <- data.frame(name="content", level=1, min=10, max=10, stringsAsFactors=FALSE)
cons <- rbind(cons, c("content", 2, 10, 10))
cons <- rbind(cons, c("content", 3, 10, 10))
opts <- list(min=10, max=30, projection.cut=0, projection.constraints=cons, 
projection.method="information")
x <- cat.sim(0.1, pool, opts, cat.stop=cat.stop.projection, debug=TRUE)
}
}
\seealso{
Other res: \code{\link{rmse}}
}

