% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projvar.R
\name{projvar}
\alias{projvar}
\title{Project Variables}
\usage{
projvar(var, struc)
}
\arguments{
\item{var}{A vector of a single variable}

\item{struc}{The output of \code{projdummies}, containing matrices necessary to project}
}
\value{
A list will be returned with the following named values:
        var - the projected variable
        delta, tau - intermediate variables
}
\description{
\code{projvar} uses the matrices from \code{projdummies} to project a variable.
In practice, all dependent and independent variables must be project for the two way regression
}
\examples{
hhid <- c("a","b","c","a","b","c" ,"a","b","c" ,"a","b","c" ,"a","b","c")
tid <- c("1","1" ,"1" ,"2","2" ,"3","3","3" ,"4","4","5" ,"5","6","6" ,"6")
w <- rep(1, 15)
x1 <- rnorm(15, mean=50, sd=10)   

struc <- projdummies(hhid, tid, w)
x1p <- projvar(x1, struc)
}
