% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simprazExample.R
\name{simprazExample}
\alias{simprazExample}
\title{Function to create files for the simulated prazosin example in Xpose}
\usage{
simprazExample(overwrite = FALSE)
}
\arguments{
\item{overwrite}{Logical. Should the function overwrite files with the same
names already in the current working directory?}
}
\description{
Creates NONMEM data, model and output files for a model of prazosin using
simulated data.
}
\details{
Creates files in the current working directory named: run1.ext run1.lst
run1.mod simpraz.dta xptab1
}
\examples{

od = setwd(tempdir()) # move to a temp directory
(cur.files <- dir()) # current files in temp directory

simprazExample(overwrite=TRUE) # write files

(new.files <- dir()[!(dir() \%in\% cur.files)])  # what files are new here?

file.remove(new.files) # remove these files
setwd(od)  # restore working directory

}
\seealso{
Other data functions: \code{\link{add_transformed_columns}},
  \code{\link{change_graphical_parameters}},
  \code{\link{change_misc_parameters}},
  \code{\link{compute.cwres}}, \code{\link{data.checkout}},
  \code{\link{data_extract_or_assign}},
  \code{\link{db.names}}, \code{\link{export.graph.par}},
  \code{\link{export.variable.definitions}},
  \code{\link{import.graph.par}},
  \code{\link{import.variable.definitions}},
  \code{\link{make.sb.data}}, \code{\link{nsim}},
  \code{\link{par_cov_summary}},
  \code{\link{read.TTE.sim.data}},
  \code{\link{read.nm.tables}},
  \code{\link{read_NM_output}},
  \code{\link{read_nm_table}},
  \code{\link{tabulate.parameters}}, \code{\link{xlabel}},
  \code{\link{xpose.data}}, \code{\link{xpose.print}},
  \code{\link{xpose4-package}}, \code{\link{xsubset}}
}
\author{
Niclas Jonsson and Andrew Hooker
}
\keyword{methods}
