% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xset_shark.R
\name{shark_plot}
\alias{shark_plot}
\alias{dofv_vs_id}
\title{Individual contributions to dOFV}
\usage{
shark_plot(
  xpdb_s,
  ...,
  .inorder = FALSE,
  type = "plt",
  alpha = 0.05,
  df = "guess",
  text_cutoff = 0.8,
  title = "Individual contributions to dOFV | @run",
  subtitle = "Based on @nind individuals, OFVs: @ofv",
  caption = "@dir",
  tag = NULL,
  ylab = "dOFV",
  xlab = "Number of individuals removed",
  opt,
  facets = NULL,
  .problem,
  .subprob,
  .method,
  quiet
)

dofv_vs_id(
  xpdb_s,
  ...,
  .inorder = FALSE,
  type = "plt",
  alpha = 0.05,
  df = "guess",
  text_cutoff = 0.8,
  title = "Individual contributions to dOFV | @run",
  subtitle = "Based on @nind individuals, OFVs: @ofv",
  caption = "@dir",
  tag = NULL,
  ylab = "dOFV",
  xlab = "Number of individuals removed",
  opt,
  facets = NULL,
  .problem,
  .subprob,
  .method,
  quiet
)
}
\arguments{
\item{xpdb_s}{<\code{xpose_set}> object}

\item{...}{See <\code{\link{two_set_dots}}>}

\item{.inorder}{See <\code{\link{two_set_dots}}>}

\item{type}{See Details.}

\item{alpha}{alpha for LRT}

\item{df}{degrees of freedom for LRT. If \code{"guess"} (default), then
use the difference in the number of unfixed parameters.}

\item{text_cutoff}{If less than 1, the percentile of absolute
individual dOFV values above which to show labels of IDs.
If above 1, the absolute number of IDs to show. To show all,
use an extreme positive number like 9999.}

\item{title}{Plot title}

\item{subtitle}{Plot subtitle}

\item{caption}{Plot caption}

\item{tag}{Plot tag}

\item{ylab}{y-axis label}

\item{xlab}{x-axis label}

\item{opt}{User-specified data options. Only some of these
will be used.}

\item{facets}{<\code{character}> vector selecting facets, or \code{NULL} (default).}

\item{.problem}{The problem to be used, by default returns the last one.}

\item{.subprob}{The subproblem to be used, by default returns the last one.}

\item{.method}{The estimation method to be used, by default returns the last one.}

\item{quiet}{Silence extra debugging output}
}
\value{
<\code{xpose_plot}> object
}
\description{
This is intended to match the overall behavior of
\code{dOFV.vs.id()} in \code{xpose4}, within the framework
of the \code{xpose_set} object.

\code{dofv_vs_id} is an alias of the function \code{shark_plot},
for recognition.
}
\details{
For type-based customization of plots:
\itemize{
\item \code{p} points (using aesthetics for \code{sharkup} and \code{sharkdn})
\item \code{l} lines for dOFV (both total dOFV and significance are plotted)
\item \code{t} text (using aesthetics for \code{shkuptxt} and \code{shkdntxt})
}

In \code{xpose4}, users can control \code{sig.drop}, but this function uses
\code{alpha} and \code{df} to determine the critical delta by the likelihood
ratio test. It is acknowledged there are situations where this may
not be valid, but it is suggested that \code{df} or \code{alpha} be adjusted
to meet the desired \code{sig.drop}.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{my_alpha <- 0.05
my_df <- 1.34 # fractional, perhaps to account for different IIVs

my_sigdrop <- -stats::qchisq(1-my_alpha, my_df)
my_sigdrop
#> [1] -4.633671
# Then use alpha=my_alpha, df=my_df in `shark_plot` call.
}\if{html}{\out{</div>}}
}
\examples{
\donttest{

pheno_set \%>\%
  # Make sure set has iofv var types defined
  focus_xpdb(everything()) \%>\%
  focus_function(backfill_iofv) \%>\%
  # Pick two models or consistent with two_set_dots()
  shark_plot(run6,run11)

pheno_set \%>\%
  # As before
  focus_xpdb(everything()) \%>\%
  focus_function(backfill_iofv) \%>\%
  # Add indicator (or use established covariate)
  mutate(APGRtest = as.numeric(as.character(APGR))<5) \%>\%
  # Pick two models or consistent with two_set_dots()
  shark_plot(run6,run11, facets = "APGRtest")

}
}
\seealso{
\code{\link[=shark_colors]{shark_colors()}}
}
